/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.LoggingLevel;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.util.CamelContextHelper;

@XmlRootElement(name="redeliveryPolicy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RedeliveryPolicyType {
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private Integer maximumRedeliveries;
    @XmlAttribute
    private Long initialRedeliveryDelay;
    @XmlAttribute
    private Double backOffMultiplier;
    @XmlAttribute
    private Boolean useExponentialBackOff;
    @XmlAttribute
    private Double collisionAvoidanceFactor;
    @XmlAttribute
    private Boolean useCollisionAvoidance;
    @XmlAttribute
    private Long maximumRedeliveryDelay;
    @XmlAttribute
    private LoggingLevel retriesExhaustedLogLevel;
    @XmlAttribute
    private LoggingLevel retryAttemptedLogLevel;

    public RedeliveryPolicy createRedeliveryPolicy(CamelContext context, RedeliveryPolicy parentPolicy) {
        if (this.ref != null) {
            return CamelContextHelper.mandatoryLookup(context, this.ref, RedeliveryPolicy.class);
        }
        RedeliveryPolicy answer = parentPolicy.copy();
        if (this.maximumRedeliveries != null) {
            answer.setMaximumRedeliveries(this.maximumRedeliveries);
        }
        if (this.initialRedeliveryDelay != null) {
            answer.setDelay(this.initialRedeliveryDelay);
        }
        if (this.retriesExhaustedLogLevel != null) {
            answer.setRetriesExhaustedLogLevel(this.retriesExhaustedLogLevel);
        }
        if (this.retryAttemptedLogLevel != null) {
            answer.setRetryAttemptedLogLevel(this.retryAttemptedLogLevel);
        }
        if (this.backOffMultiplier != null) {
            answer.setBackOffMultiplier(this.backOffMultiplier);
        }
        if (this.useExponentialBackOff != null) {
            answer.setUseExponentialBackOff(this.useExponentialBackOff);
        }
        if (this.collisionAvoidanceFactor != null) {
            answer.setCollisionAvoidanceFactor(this.collisionAvoidanceFactor);
        }
        if (this.useCollisionAvoidance != null) {
            answer.setUseCollisionAvoidance(this.useCollisionAvoidance);
        }
        if (this.maximumRedeliveryDelay != null) {
            answer.setMaximumRedeliveryDelay(this.maximumRedeliveryDelay);
        }
        return answer;
    }

    public String toString() {
        return "RedeliveryPolicy[maximumRedeliveries: " + this.maximumRedeliveries + "]";
    }

    public RedeliveryPolicyType backOffMultiplier(double backOffMultiplier) {
        this.setBackOffMultiplier(backOffMultiplier);
        return this;
    }

    public RedeliveryPolicyType collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.setCollisionAvoidanceFactor(collisionAvoidancePercent * 0.01);
        return this;
    }

    public RedeliveryPolicyType collisionAvoidanceFactor(double collisionAvoidanceFactor) {
        this.setCollisionAvoidanceFactor(collisionAvoidanceFactor);
        return this;
    }

    public RedeliveryPolicyType initialRedeliveryDelay(long initialRedeliveryDelay) {
        this.setInitialRedeliveryDelay(initialRedeliveryDelay);
        return this;
    }

    public RedeliveryPolicyType retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.setRetriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public RedeliveryPolicyType retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.setRetryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public RedeliveryPolicyType maximumRedeliveries(int maximumRedeliveries) {
        this.setMaximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public RedeliveryPolicyType useCollisionAvoidance() {
        this.setUseCollisionAvoidance(Boolean.TRUE);
        return this;
    }

    public RedeliveryPolicyType useExponentialBackOff() {
        this.setUseExponentialBackOff(Boolean.TRUE);
        return this;
    }

    public RedeliveryPolicyType maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.setMaximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public RedeliveryPolicyType ref(String ref) {
        this.setRef(ref);
        return this;
    }

    public Double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(Double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public Double getCollisionAvoidanceFactor() {
        return this.collisionAvoidanceFactor;
    }

    public void setCollisionAvoidanceFactor(Double collisionAvoidanceFactor) {
        this.collisionAvoidanceFactor = collisionAvoidanceFactor;
    }

    public Long getInitialRedeliveryDelay() {
        return this.initialRedeliveryDelay;
    }

    public void setInitialRedeliveryDelay(Long initialRedeliveryDelay) {
        this.initialRedeliveryDelay = initialRedeliveryDelay;
    }

    public Integer getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(Integer maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public Boolean getUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(Boolean useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public Boolean getUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(Boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public Long getMaximumRedeliveryDelay() {
        return this.maximumRedeliveryDelay;
    }

    public void setMaximumRedeliveryDelay(Long maximumRedeliveryDelay) {
        this.maximumRedeliveryDelay = maximumRedeliveryDelay;
    }

    public void setRetriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.retriesExhaustedLogLevel = retriesExhaustedLogLevel;
    }

    public LoggingLevel getRetriesExhaustedLogLevel() {
        return this.retriesExhaustedLogLevel;
    }

    public void setRetryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.retryAttemptedLogLevel = retryAttemptedLogLevel;
    }

    public LoggingLevel getRetryAttemptedLogLevel() {
        return this.retryAttemptedLogLevel;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }
}

