/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertBodyProcessor
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(ConvertBodyProcessor.class);
    private final Class type;

    public ConvertBodyProcessor(Class type) {
        this.type = type;
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Object value = null;
        try {
            value = in.getBody(this.type);
        }
        catch (NoTypeConversionAvailableException e) {
            LOG.warn((Object)("Could not convert body of IN message: " + in + " to type: " + this.type.getName()));
        }
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(in);
            out.setBody(value);
        } else {
            in.setBody(value);
        }
    }
}

