/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipeline
extends MulticastProcessor
implements AsyncProcessor {
    private static final transient Log LOG = LogFactory.getLog(Pipeline.class);

    public Pipeline(Collection<Processor> processors) {
        super(processors);
    }

    public static Processor newInstance(List<Processor> processors) {
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        return new Pipeline(processors);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange original, AsyncCallback callback) {
        Exchange nextExchange;
        block5: {
            AsyncProcessor processor;
            boolean sync;
            Iterator<Processor> processors = this.getProcessors().iterator();
            nextExchange = original;
            boolean first = true;
            do {
                boolean exceptionHandled = Pipeline.hasExceptionBeenHandled(nextExchange);
                if (nextExchange.isFailed() || exceptionHandled) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Message exchange has failed so breaking out of pipeline: " + nextExchange + " exception: " + nextExchange.getException() + " fault: " + nextExchange.getFault(false) + (exceptionHandled ? " handled by the error handler" : "")));
                    }
                    break block5;
                }
                if (!processors.hasNext()) break block5;
                processor = AsyncProcessorTypeConverter.convert(processors.next());
                if (first) {
                    first = false;
                    continue;
                }
                nextExchange = this.createNextExchange(processor, nextExchange);
            } while (sync = this.process(original, nextExchange, callback, processors, processor));
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing compelete for exchangeId: " + original.getExchangeId() + " >>> " + nextExchange));
        }
        ExchangeHelper.copyResults(original, nextExchange);
        callback.done(true);
        return true;
    }

    private boolean process(final Exchange original, final Exchange exchange, final AsyncCallback callback, final Iterator<Processor> processors, AsyncProcessor processor) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " >>> " + exchange));
        }
        return processor.process(exchange, new AsyncCallback(){

            public void done(boolean sync) {
                if (sync) {
                    return;
                }
                Exchange nextExchange = exchange;
                while (processors.hasNext()) {
                    AsyncProcessor processor = AsyncProcessorTypeConverter.convert((Processor)processors.next());
                    boolean exceptionHandled = Pipeline.hasExceptionBeenHandled(nextExchange);
                    if (nextExchange.isFailed() || exceptionHandled) {
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug((Object)("Message exchange has failed so breaking out of pipeline: " + nextExchange + " exception: " + nextExchange.getException() + " fault: " + nextExchange.getFault(false) + (exceptionHandled ? " handled by the error handler" : "")));
                        break;
                    }
                    sync = Pipeline.this.process(original, nextExchange = Pipeline.this.createNextExchange(processor, nextExchange), callback, processors, processor);
                    if (sync) continue;
                    return;
                }
                ExchangeHelper.copyResults(original, nextExchange);
                callback.done(false);
            }
        });
    }

    private static boolean hasExceptionBeenHandled(Exchange nextExchange) {
        return Boolean.TRUE.equals(nextExchange.getProperty("CamelExceptionHandled"));
    }

    protected Exchange createNextExchange(Processor producer, Exchange previousExchange) {
        Exchange answer = previousExchange.newInstance();
        answer.setExchangeId(previousExchange.getExchangeId());
        answer.getProperties().putAll(previousExchange.getProperties());
        Message previousOut = previousExchange.getOut(false);
        Message in = answer.getIn();
        if (previousOut != null) {
            in.copyFrom(previousOut);
        } else {
            in.copyFrom(previousExchange.getIn());
        }
        return answer;
    }

    @Override
    public String toString() {
        return "Pipeline" + this.getProcessors();
    }
}

