/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutingSlip
extends ServiceSupport
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(RoutingSlip.class);
    private final String header;
    private final String uriDelimiter;
    private ProducerCache<Exchange> producerCache = new ProducerCache();

    public RoutingSlip(String header) {
        this(header, ",");
    }

    public RoutingSlip(String header, String uriDelimiter) {
        ObjectHelper.notNull(header, "header");
        ObjectHelper.notNull(uriDelimiter, "uriDelimiter");
        this.header = header;
        this.uriDelimiter = uriDelimiter;
    }

    public String toString() {
        return "RoutingSlip[header=" + this.header + " uriDelimiter=" + this.uriDelimiter + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        String[] recipients = this.recipients(message);
        Exchange current = exchange;
        for (String nextRecipient : recipients) {
            Endpoint<Exchange> endpoint = this.resolveEndpoint(exchange, nextRecipient);
            Producer<Exchange> producer = this.producerCache.getProducer(endpoint);
            Exchange ex = current.newInstance();
            this.updateRoutingSlip(current);
            this.copyOutToIn(ex, current);
            producer.process(ex);
            current = ex;
        }
        ExchangeHelper.copyResults(exchange, current);
    }

    protected Endpoint<Exchange> resolveEndpoint(Exchange exchange, Object recipient) {
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    @Override
    protected void doStop() throws Exception {
        this.producerCache.stop();
    }

    @Override
    protected void doStart() throws Exception {
    }

    private void updateRoutingSlip(Exchange current) {
        Message message = this.getResultMessage(current);
        message.setHeader(this.header, this.removeFirstElement(this.recipients(message)));
    }

    private Message getResultMessage(Exchange exchange) {
        Message message = exchange.getOut(false);
        if (message == null) {
            message = exchange.getIn();
        }
        return message;
    }

    private String[] recipients(Message message) {
        Object headerValue = message.getHeader(this.header);
        if (headerValue != null && !headerValue.equals("")) {
            return headerValue.toString().split(this.uriDelimiter);
        }
        return new String[0];
    }

    private String removeFirstElement(String[] elements) {
        CollectionStringBuffer updatedElements = new CollectionStringBuffer(this.uriDelimiter);
        for (int i = 1; i < elements.length; ++i) {
            updatedElements.append(elements[i]);
        }
        return updatedElements.toString();
    }

    private void copyOutToIn(Exchange result, Exchange source) {
        result.setException(source.getException());
        Message fault = source.getFault(false);
        if (fault != null) {
            result.getFault(true).copyFrom(fault);
        }
        result.setIn(this.getResultMessage(source));
        result.getProperties().clear();
        result.getProperties().putAll(source.getProperties());
    }
}

