/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.resequencer.ResequencerEngine;
import org.apache.camel.processor.resequencer.SequenceElementComparator;
import org.apache.camel.processor.resequencer.SequenceSender;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamResequencer
extends ServiceSupport
implements SequenceSender<Exchange>,
Processor {
    private static final long DELIVERY_ATTEMPT_INTERVAL = 1000L;
    private ExceptionHandler exceptionHandler = new LoggingExceptionHandler(this.getClass());
    private ResequencerEngine<Exchange> engine;
    private Processor processor;
    private Delivery delivery;
    private int capacity;

    public StreamResequencer(Processor processor, SequenceElementComparator<Exchange> comparator) {
        this.engine = new ResequencerEngine<Exchange>(comparator);
        this.engine.setSequenceSender(this);
        this.processor = processor;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getTimeout() {
        return this.engine.getTimeout();
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setTimeout(long timeout) {
        this.engine.setTimeout(timeout);
    }

    public String toString() {
        return "StreamResequencer[to: " + this.processor + "]";
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
        this.delivery = new Delivery();
        this.engine.start();
        this.delivery.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.engine.stop();
        ServiceHelper.stopServices(this.processor);
    }

    @Override
    public void sendElement(Exchange o) throws Exception {
        this.processor.process(o);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        while (this.engine.size() >= this.capacity) {
            Thread.sleep(this.getTimeout());
        }
        this.engine.insert(exchange);
        this.delivery.request();
    }

    private class Delivery
    extends Thread {
        private volatile boolean cancelRequested;

        public Delivery() {
            super("Delivery Thread");
        }

        public void run() {
            while (true) {
                block5: {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        if (!this.cancelRequested) break block5;
                        return;
                    }
                }
                try {
                    StreamResequencer.this.engine.deliver();
                    continue;
                }
                catch (Exception e) {
                    StreamResequencer.this.exceptionHandler.handleException(e);
                    continue;
                }
                break;
            }
        }

        public void cancel() {
            this.cancelRequested = true;
            this.interrupt();
        }

        public void request() {
            this.interrupt();
        }
    }
}

