/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.converter.stream.StreamCache;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.ObjectHelper;

public class TraceFormatter {
    private int breadCrumbLength;
    private int nodeLength;
    private boolean showBreadCrumb = true;
    private boolean showNode = true;
    private boolean showExchangeId;
    private boolean showShortExchangeId;
    private boolean showExchangePattern = true;
    private boolean showProperties = true;
    private boolean showHeaders = true;
    private boolean showBody = true;
    private boolean showBodyType = true;
    private boolean showOutBody;
    private boolean showOutBodyType;
    private boolean showException = true;

    public Object format(TraceInterceptor interceptor, Exchange exchange) {
        Message in = exchange.getIn();
        Message out = exchange.getOut(false);
        Throwable exception = exchange.getException();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getExchangeAndNode(interceptor, exchange));
        if (this.showExchangePattern) {
            sb.append(", Pattern:").append((Object)exchange.getPattern()).append(" ");
        }
        if (this.showProperties && !exchange.getProperties().isEmpty()) {
            sb.append(", Properties:").append(exchange.getProperties()).append(" ");
        }
        if (this.showHeaders && !in.getHeaders().isEmpty()) {
            sb.append(", Headers:").append(in.getHeaders()).append(" ");
        }
        if (this.showBodyType) {
            sb.append(", BodyType:").append(this.getBodyTypeAsString(in)).append(" ");
        }
        if (this.showBody) {
            sb.append(", Body:").append(this.getBodyAsString(in)).append(" ");
        }
        if (this.showOutBodyType && out != null) {
            sb.append(", OutBodyType:").append(this.getBodyTypeAsString(out)).append(" ");
        }
        if (this.showOutBody && out != null) {
            sb.append(", OutBody:").append(this.getBodyAsString(out)).append(" ");
        }
        if (this.showException && exception != null) {
            sb.append(", Exception:").append(exception);
        }
        return sb.toString();
    }

    public boolean isShowBody() {
        return this.showBody;
    }

    public void setShowBody(boolean showBody) {
        this.showBody = showBody;
    }

    public boolean isShowBodyType() {
        return this.showBodyType;
    }

    public void setShowBodyType(boolean showBodyType) {
        this.showBodyType = showBodyType;
    }

    public void setShowOutBody(boolean showOutBody) {
        this.showOutBody = showOutBody;
    }

    public boolean isShowOutBody() {
        return this.showOutBody;
    }

    public void setShowOutBodyType(boolean showOutBodyType) {
        this.showOutBodyType = showOutBodyType;
    }

    public boolean isShowOutBodyType() {
        return this.showOutBodyType;
    }

    public boolean isShowBreadCrumb() {
        return this.showBreadCrumb;
    }

    public void setShowBreadCrumb(boolean showBreadCrumb) {
        this.showBreadCrumb = showBreadCrumb;
    }

    public boolean isShowExchangeId() {
        return this.showExchangeId;
    }

    public void setShowExchangeId(boolean showExchangeId) {
        this.showExchangeId = showExchangeId;
    }

    public boolean isShowHeaders() {
        return this.showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean showProperties) {
        this.showProperties = showProperties;
    }

    public boolean isShowNode() {
        return this.showNode;
    }

    public void setShowNode(boolean showNode) {
        this.showNode = showNode;
    }

    public boolean isShowExchangePattern() {
        return this.showExchangePattern;
    }

    public void setShowExchangePattern(boolean showExchangePattern) {
        this.showExchangePattern = showExchangePattern;
    }

    public boolean isShowException() {
        return this.showException;
    }

    public void setShowException(boolean showException) {
        this.showException = showException;
    }

    public int getBreadCrumbLength() {
        return this.breadCrumbLength;
    }

    public void setBreadCrumbLength(int breadCrumbLength) {
        this.breadCrumbLength = breadCrumbLength;
    }

    public boolean isShowShortExchangeId() {
        return this.showShortExchangeId;
    }

    public void setShowShortExchangeId(boolean showShortExchangeId) {
        this.showShortExchangeId = showShortExchangeId;
    }

    public int getNodeLength() {
        return this.nodeLength;
    }

    public void setNodeLength(int nodeLength) {
        this.nodeLength = nodeLength;
    }

    protected Object getBreadCrumbID(Exchange exchange) {
        UnitOfWork unitOfWork = exchange.getUnitOfWork();
        return unitOfWork.getId();
    }

    protected Object getBodyAsString(Message in) {
        if (in == null) {
            return null;
        }
        StreamCache newBody = null;
        try {
            newBody = in.getBody(StreamCache.class);
            if (newBody != null) {
                in.setBody(newBody);
            }
        }
        catch (NoTypeConversionAvailableException ex) {
            // empty catch block
        }
        Object answer = null;
        try {
            answer = in.getBody(String.class);
        }
        catch (NoTypeConversionAvailableException ex) {
            answer = in.getBody();
        }
        if (newBody != null) {
            newBody.reset();
        }
        return answer;
    }

    protected Object getBodyTypeAsString(Message message) {
        if (message == null) {
            return null;
        }
        String answer = ObjectHelper.classCanonicalName(message.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }

    protected String getNodeMessage(TraceInterceptor interceptor) {
        String message = interceptor.getNode().getShortName() + "(" + interceptor.getNode().getLabel() + ")";
        if (this.nodeLength > 0) {
            return String.format("%1$-" + this.nodeLength + "." + this.nodeLength + "s", message);
        }
        return message;
    }

    protected String getExchangeAndNode(TraceInterceptor interceptor, Exchange exchange) {
        String id = "";
        String node = "";
        if (!(this.showBreadCrumb || this.showExchangeId || this.showShortExchangeId || this.showNode)) {
            return "";
        }
        if (this.showBreadCrumb) {
            id = this.getBreadCrumbID(exchange).toString();
        } else if (this.showExchangeId || this.showShortExchangeId) {
            id = this.getBreadCrumbID(exchange).toString();
            if (this.showShortExchangeId) {
                id = id.substring(id.indexOf("/") + 1);
            }
        }
        if (this.showNode) {
            node = this.getNodeMessage(interceptor);
        }
        String result = interceptor.shouldTraceOutExchanges() && exchange.getOut(false) != null ? node.trim() + " -> " + id.trim() : id.trim() + " -> " + node.trim();
        if (this.breadCrumbLength > 0) {
            return String.format("%1$-" + this.breadCrumbLength + "." + this.breadCrumbLength + "s", result).trim();
        }
        return result.trim();
    }
}

