/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverUtil<T> {
    protected static final transient Log LOG = LogFactory.getLog(ResolverUtil.class);
    private Set<Class<? extends T>> matches = new HashSet<Class<? extends T>>();
    private Set<ClassLoader> classLoaders;

    public Set<Class<? extends T>> getClasses() {
        return this.matches;
    }

    public Set<ClassLoader> getClassLoaders() {
        if (this.classLoaders == null) {
            this.classLoaders = new HashSet<ClassLoader>();
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                this.classLoaders.add(ccl);
            }
            this.classLoaders.add(ResolverUtil.class.getClassLoader());
        }
        return this.classLoaders;
    }

    public void setClassLoaders(Set<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders;
    }

    public void findImplementations(Class parent, String ... packageNames) {
        if (packageNames == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for implementations of " + parent.getName() + " in packages: " + Arrays.asList(packageNames)));
        }
        IsA test = new IsA(parent);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found: " + this.getClasses()));
        }
    }

    public void findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for annotations of " + annotation.getName() + " in packages: " + Arrays.asList(packageNames)));
        }
        AnnotatedWith test = new AnnotatedWith(annotation, true);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found: " + this.getClasses()));
        }
    }

    public void find(Test test, String packageName) {
        packageName = packageName.replace('.', '/');
        Set<ClassLoader> set = this.getClassLoaders();
        LOG.debug((Object)"Using only regular classloaders");
        for (ClassLoader classLoader : set) {
            this.find(test, packageName, classLoader);
        }
    }

    protected void find(Test test, String packageName, ClassLoader loader) {
        Enumeration<URL> urls;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Searching for: " + test + " in package: " + packageName + " using classloader: " + loader.getClass().getName()));
        }
        try {
            urls = this.getResources(loader, packageName);
            if (!urls.hasMoreElements()) {
                LOG.trace((Object)"No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Could not read package: " + packageName), (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                InputStream stream;
                File file;
                url = urls.nextElement();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("URL from classloader: " + url));
                }
                String urlPath = url.getFile();
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Decoded urlPath: " + urlPath));
                }
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (url.toString().startsWith("bundle:") || urlPath.startsWith("bundle:")) {
                    LOG.trace((Object)"It's a virtual osgi bundle, skipping");
                    continue;
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Scanning for classes in [" + urlPath + "] matching criteria: " + test));
                }
                if ((file = new File(urlPath)).isDirectory()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Loading from directory: " + file));
                    }
                    this.loadImplementationsInDirectory(test, packageName, file);
                    continue;
                }
                if (urlPath.startsWith("http:")) {
                    LOG.debug((Object)"The current jar is accessed via http");
                    URL urlStream = new URL(urlPath);
                    URLConnection con = urlStream.openConnection();
                    con.setUseCaches(false);
                    stream = con.getInputStream();
                } else {
                    stream = new FileInputStream(file);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading from jar: " + file));
                }
                this.loadImplementationsInJar(test, packageName, stream, urlPath);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Could not read entries in url: " + url), (Throwable)ioe);
            }
        }
    }

    protected Enumeration<URL> getResources(ClassLoader loader, String packageName) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Getting resource URL for package: " + packageName + " with classloader: " + loader));
        }
        return loader.getResources(packageName);
    }

    private void loadImplementationsInDirectory(Test test, String parent, File location) {
        File[] files = location.listFiles();
        StringBuilder builder = null;
        for (File file : files) {
            String packageOrClass;
            builder = new StringBuilder(100);
            String name = file.getName();
            if (name == null) continue;
            name = name.trim();
            builder.append(parent).append("/").append(name);
            String string = packageOrClass = parent == null ? name : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(test, packageOrClass, file);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            this.addIfMatching(test, packageOrClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImplementationsInJar(Test test, String parent, InputStream stream, String urlPath) {
        JarInputStream jarStream = null;
        try {
            JarEntry entry;
            jarStream = new JarInputStream(stream);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (name == null) continue;
                name = name.trim();
                if (entry.isDirectory() || !name.startsWith(parent) || !name.endsWith(".class")) continue;
                this.addIfMatching(test, name);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)("Could not search jar file '" + urlPath + "' for classes matching criteria: " + test + " due to an IOException: " + ioe.getMessage()), (Throwable)ioe);
        }
        finally {
            ObjectHelper.close(jarStream, urlPath, LOG);
        }
    }

    protected void addIfMatching(Test test, String fqn) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            Set<ClassLoader> set = this.getClassLoaders();
            boolean found = false;
            for (ClassLoader classLoader : set) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Testing for class " + externalName + " matches criteria [" + test + "]"));
                }
                try {
                    Class<?> type = classLoader.loadClass(externalName);
                    if (test.matches(type)) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Found class: " + type + " in classloader: " + classLoader));
                        }
                        this.matches.add(type);
                    }
                    found = true;
                    break;
                }
                catch (ClassNotFoundException e) {
                    LOG.debug((Object)("Could not find class '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e), (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    LOG.debug((Object)("Could not find the class defintion '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e), (Throwable)e);
                }
            }
            if (!found) {
                LOG.warn((Object)("Could not find class '" + fqn + "' in any classloaders: " + set));
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Could not examine class '" + fqn + "' due to a " + t.getClass().getName() + " with message: " + t.getMessage()), t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedWith
    implements Test {
        private Class<? extends Annotation> annotation;
        private boolean checkMetaAnnotations;

        public AnnotatedWith(Class<? extends Annotation> annotation) {
            this(annotation, false);
        }

        public AnnotatedWith(Class<? extends Annotation> annotation, boolean checkMetaAnnotations) {
            this.annotation = annotation;
            this.checkMetaAnnotations = checkMetaAnnotations;
        }

        @Override
        public boolean matches(Class type) {
            return type != null && ObjectHelper.hasAnnotation(type, this.annotation, this.checkMetaAnnotations);
        }

        public String toString() {
            return "annotated with @" + this.annotation.getSimpleName();
        }
    }

    public static class IsA
    implements Test {
        private Class parent;

        public IsA(Class parentType) {
            this.parent = parentType;
        }

        public boolean matches(Class type) {
            return type != null && this.parent.isAssignableFrom(type);
        }

        public String toString() {
            return "is assignable to " + this.parent.getSimpleName();
        }
    }

    public static interface Test {
        public boolean matches(Class var1);
    }
}

