/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.expression;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.expression.JAXPXPathExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JAXPXPathXStreamExpression
extends JAXPXPathExpression {
    protected Log logger = LogFactory.getLog(JAXPXPathXStreamExpression.class);
    private XStream xStream;

    public JAXPXPathXStreamExpression() {
    }

    public JAXPXPathXStreamExpression(String xpath) {
        super(xpath);
    }

    public Object evaluate(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        DomReader streamReader;
        Object node = super.evaluate(exchange, message, XPathConstants.NODE);
        if (node instanceof Document) {
            streamReader = new DomReader((Document)node);
        } else if (node instanceof Element) {
            streamReader = new DomReader((Element)node);
        } else {
            throw new IllegalArgumentException("DOMResult contains neither Document nor Element: " + node.getClass().getName());
        }
        return this.getXStream().unmarshal((HierarchicalStreamReader)streamReader);
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    private XStream createXStream() {
        XStream answer = new XStream();
        try {
            answer.alias("invoke", Class.forName("org.logicblaze.lingo.LingoInvocation"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return answer;
    }
}

