/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.bindings.soap.interceptors;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.bindings.soap.Soap11;
import org.apache.servicemix.soap.bindings.soap.SoapConstants;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.bindings.soap.SoapVersion;
import org.apache.servicemix.soap.core.AbstractInterceptor;
import org.apache.servicemix.soap.util.stax.StaxUtil;

public class SoapFaultOutInterceptor
extends AbstractInterceptor {
    public void handleMessage(Message message) {
        block5: {
            Exception exception = message.getContent(Exception.class);
            XMLStreamWriter writer = message.getContent(XMLStreamWriter.class);
            SoapVersion soapVersion = message.get(SoapVersion.class);
            try {
                if (!(exception instanceof SoapFault)) break block5;
                SoapFault fault = (SoapFault)exception;
                if (soapVersion == null) {
                    soapVersion = Soap11.getInstance();
                }
                if (soapVersion.getVersion() == 1.1) {
                    this.writeSoap11Fault(writer, fault, soapVersion);
                    break block5;
                }
                if (soapVersion.getVersion() == 1.2) {
                    this.writeSoap12Fault(writer, fault, soapVersion);
                    break block5;
                }
                throw new IllegalStateException("Unrecognized soap version: " + soapVersion.getVersion());
            }
            catch (XMLStreamException e) {
                throw new Fault(e);
            }
        }
    }

    private void writeSoap11Fault(XMLStreamWriter writer, SoapFault fault, SoapVersion soapVersion) throws XMLStreamException {
        Source details;
        String reason;
        fault.translateCodeTo11();
        StaxUtil.writeStartElement(writer, soapVersion.getFault());
        QName code = fault.getCode();
        if (code != null) {
            StaxUtil.writeStartElement(writer, SoapConstants.SOAP_11_FAULTCODE);
            StaxUtil.writeTextQName(writer, code);
            writer.writeEndElement();
        }
        if ((reason = fault.getReason()) == null && fault.getCause() != null) {
            reason = fault.getCause().toString();
        }
        StaxUtil.writeStartElement(writer, SoapConstants.SOAP_11_FAULTSTRING);
        if (reason != null) {
            writer.writeCharacters(reason);
        }
        writer.writeEndElement();
        URI node = fault.getNode();
        if (node != null) {
            StaxUtil.writeStartElement(writer, SoapConstants.SOAP_11_FAULTACTOR);
            writer.writeCharacters(node.toString());
            writer.writeEndElement();
        }
        if ((details = fault.getDetails()) != null) {
            StaxUtil.writeStartElement(writer, SoapConstants.SOAP_11_FAULTDETAIL);
            XMLStreamReader reader = StaxUtil.createReader(details);
            StaxUtil.copy(reader, writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeSoap12Fault(XMLStreamWriter writer, SoapFault fault, SoapVersion soapVersion) throws XMLStreamException {
        Source details;
        URI role;
        String reason;
        fault.translateCodeTo12();
        StaxUtil.writeStartElement(writer, soapVersion.getFault());
        QName code = fault.getCode();
        if (code != null) {
            StaxUtil.writeStartElement(writer, SoapConstants.SOAP_12_FAULTCODE);
            StaxUtil.writeStartElement(writer, SoapConstants.SOAP_12_FAULTVALUE);
            StaxUtil.writeTextQName(writer, code);
            writer.writeEndElement();
            QName subcode = fault.getSubcode();
            if (subcode != null) {
                StaxUtil.writeStartElement(writer, SoapConstants.SOAP_12_FAULTSUBCODE);
                StaxUtil.writeStartElement(writer, SoapConstants.SOAP_12_FAULTVALUE);
                StaxUtil.writeTextQName(writer, subcode);
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if ((reason = fault.getReason()) == null && fault.getCause() != null) {
            reason = fault.getCause().toString();
        }
        StaxUtil.writeStartElement(writer, SoapConstants.SOAP_12_FAULTREASON);
        StaxUtil.writeStartElement(writer, SoapConstants.SOAP_12_FAULTTEXT);
        writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", "en");
        if (reason != null) {
            writer.writeCharacters(reason);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        URI node = fault.getNode();
        if (node != null) {
            StaxUtil.writeStartElement(writer, SoapConstants.SOAP_12_FAULTNODE);
            writer.writeCharacters(node.toString());
            writer.writeEndElement();
        }
        if ((role = fault.getRole()) != null) {
            StaxUtil.writeStartElement(writer, SoapConstants.SOAP_12_FAULTROLE);
            writer.writeCharacters(role.toString());
            writer.writeEndElement();
        }
        if ((details = fault.getDetails()) != null) {
            StaxUtil.writeStartElement(writer, SoapConstants.SOAP_12_FAULTDETAIL);
            XMLStreamReader reader = StaxUtil.createReader(details);
            StaxUtil.copy(reader, writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

