/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Service;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.source.NodeDataWriter;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.handler.logical.DispatchLogicalHandlerInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.service.Service;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Node;

public class DispatchOutDatabindingInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchOutDatabindingInterceptor.class);
    private DispatchOutDatabindingEndingInterceptor ending = new DispatchOutDatabindingEndingInterceptor();
    private Service.Mode mode;

    public DispatchOutDatabindingInterceptor(Service.Mode mode) {
        super("write");
        this.mode = mode;
    }

    public void handleMessage(Message message) throws Fault {
        Object obj = null;
        List result = message.getContent(List.class);
        if (result != null) {
            obj = result.get(0);
            message.setContent(Object.class, obj);
        } else {
            obj = message.getContent(Object.class);
        }
        message.removeContent(Object.class);
        if (obj == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("DISPATCH_OBJECT_CANNOT_BE_NULL", LOG, new Object[0]));
        }
        if (message instanceof SoapMessage) {
            Source source = null;
            if (this.mode == Service.Mode.PAYLOAD) {
                source = this.handlePayloadMode(obj, message);
            } else {
                if (obj instanceof DataSource) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("DISPATCH_OBJECT_NOT_SUPPORTED_SOAPBINDING", LOG, "DataSource", "MESSAGE"));
                }
                if (obj instanceof SOAPMessage) {
                    source = this.handleSOAPMessage(obj, message);
                } else if (obj instanceof Source) {
                    source = (Source)obj;
                }
            }
            PostDispatchOutLogicalHandlerInterceptor postSoap = new PostDispatchOutLogicalHandlerInterceptor();
            message.getInterceptorChain().add(postSoap);
            message.setContent(Source.class, source);
        } else if (message instanceof XMLMessage) {
            if (obj instanceof SOAPMessage) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("DISPATCH_OBJECT_NOT_SUPPORTED_XMLBINDING", LOG, "SOAPMessage", "PAYLOAD/MESSAGE"));
            }
            if (this.mode == Service.Mode.PAYLOAD && obj instanceof DataSource) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("DISPATCH_OBJECT_NOT_SUPPORTED_XMLBINDING", LOG, "DataSource", "PAYLOAD"));
            }
            if (obj instanceof DataSource) {
                message.setContent(DataSource.class, obj);
            } else if (obj instanceof Source) {
                message.setContent(Source.class, obj);
            } else {
                try {
                    Service service = message.getExchange().get(Service.class);
                    DataWriter<XMLStreamWriter> dataWriter = this.getDataWriter(message, service, XMLStreamWriter.class);
                    W3CDOMStreamWriter xmlWriter = new W3CDOMStreamWriter();
                    dataWriter.write(obj, xmlWriter);
                    DOMSource source = new DOMSource(xmlWriter.getDocument().getDocumentElement());
                    message.setContent(Source.class, source);
                }
                catch (ParserConfigurationException e) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("EXCEPTION_WRITING_OBJECT", LOG, new Object[0]), (Throwable)e);
                }
            }
        }
        message.getInterceptorChain().add(this.ending);
    }

    private Source handleSOAPMessage(Object obj, Message message) {
        SOAPMessage soapMessage = (SOAPMessage)obj;
        try {
            soapMessage.getSOAPPart().getEnvelope();
        }
        catch (SOAPException e1) {
            // empty catch block
        }
        DOMSource source = new DOMSource((Node)soapMessage.getSOAPPart());
        if (soapMessage.countAttachments() > 0) {
            if (message.getAttachments() == null) {
                message.setAttachments(new ArrayList<Attachment>(soapMessage.countAttachments()));
            }
            Iterator it = CastUtils.cast(soapMessage.getAttachments());
            while (it.hasNext()) {
                AttachmentPart part = (AttachmentPart)it.next();
                AttachmentImpl att = new AttachmentImpl(part.getContentId());
                try {
                    att.setDataHandler(part.getDataHandler());
                }
                catch (SOAPException e) {
                    throw new Fault(e);
                }
                Iterator it2 = CastUtils.cast(part.getAllMimeHeaders());
                while (it2.hasNext()) {
                    MimeHeader header = (MimeHeader)it2.next();
                    att.setHeader(header.getName(), header.getValue());
                }
                message.getAttachments().add(att);
            }
        }
        return source;
    }

    private Source handlePayloadMode(Object obj, Message message) {
        Source source = null;
        if (obj instanceof SOAPMessage || obj instanceof DataSource) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("DISPATCH_OBJECT_NOT_SUPPORTED_SOAPBINDING", LOG, obj.getClass(), "PAYLOAD"));
        }
        if (obj instanceof Source) {
            source = (Source)obj;
        } else {
            try {
                Service service = message.getExchange().get(Service.class);
                SOAPMessage msg = this.newSOAPMessage(null, ((SoapMessage)message).getVersion());
                DataWriter<Node> dataWriter = this.getDataWriter(message, service, Node.class);
                dataWriter.write(obj, (Node)msg.getSOAPBody());
                source = new DOMSource(DOMUtils.getChild((Node)msg.getSOAPBody(), 1));
            }
            catch (Exception e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("EXCEPTION_WRITING_OBJECT", LOG, new Object[0]), (Throwable)e);
            }
        }
        return source;
    }

    private SOAPMessage newSOAPMessage(InputStream is, SoapVersion version) throws Exception {
        SOAPMessage msg = null;
        MimeHeaders headers = new MimeHeaders();
        MessageFactory msgFactory = null;
        if (version == null || version instanceof Soap11) {
            msgFactory = MessageFactory.newInstance();
        } else if (version instanceof Soap12) {
            msgFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        }
        msg = is != null ? msgFactory.createMessage(headers, is) : msgFactory.createMessage();
        msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        return msg;
    }

    private void doTransform(Object obj, OutputStream os) throws TransformerException, IOException {
        if (obj instanceof Source) {
            Transformer transformer = XMLUtils.newTransformer();
            transformer.transform((Source)obj, new StreamResult(os));
        }
        if (obj instanceof DataSource) {
            InputStream is = ((DataSource)obj).getInputStream();
            IOUtils.copy(is, os);
            is.close();
        }
    }

    private class PostDispatchOutLogicalHandlerInterceptor
    extends AbstractInDatabindingInterceptor {
        public PostDispatchOutLogicalHandlerInterceptor() {
            super("pre-marshal");
            this.addAfter(DispatchLogicalHandlerInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            SOAPMessage obj = null;
            if (message instanceof SoapMessage) {
                DOMSource ds;
                Source source = message.getContent(Source.class);
                message.removeContent(Source.class);
                if (source instanceof DOMSource && (ds = (DOMSource)source).getNode() instanceof SOAPPart) {
                    try {
                        ((SOAPPart)ds.getNode()).getEnvelope();
                    }
                    catch (SOAPException e) {
                        // empty catch block
                    }
                }
                if (DispatchOutDatabindingInterceptor.this.mode == Service.Mode.PAYLOAD) {
                    try {
                        obj = DispatchOutDatabindingInterceptor.this.newSOAPMessage(null, ((SoapMessage)message).getVersion());
                        NodeDataWriter dataWriter = new NodeDataWriter();
                        dataWriter.write((Object)source, obj.getSOAPBody());
                    }
                    catch (Exception e) {
                        throw new Fault(new org.apache.cxf.common.i18n.Message("EXCEPTION_WRITING_OBJECT", LOG, new Object[0]), (Throwable)e);
                    }
                }
                try {
                    SoapVersion version = ((SoapMessage)message).getVersion();
                    MessageFactory msgFactory = null;
                    if (version == null || version instanceof Soap11) {
                        msgFactory = MessageFactory.newInstance();
                    } else if (version instanceof Soap12) {
                        msgFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
                    }
                    SOAPMessage msg = msgFactory.createMessage();
                    msg.getSOAPPart().setContent(source);
                    if (message.getAttachments() != null) {
                        for (Attachment att : message.getAttachments()) {
                            AttachmentPart part = msg.createAttachmentPart(att.getDataHandler());
                            if (att.getId() != null) {
                                part.setContentId(att.getId());
                            }
                            Iterator<String> it = att.getHeaderNames();
                            while (it.hasNext()) {
                                String s = it.next();
                                part.setMimeHeader(s, att.getHeader(s));
                            }
                            msg.addAttachmentPart(part);
                        }
                    }
                    msg.saveChanges();
                    obj = msg;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Fault(e);
                }
                message.setContent(SOAPMessage.class, obj);
            }
        }
    }

    private class DispatchOutDatabindingEndingInterceptor
    extends AbstractOutDatabindingInterceptor {
        public DispatchOutDatabindingEndingInterceptor() {
            super("write-ending");
        }

        public void handleMessage(Message message) throws Fault {
            XMLStreamWriter xmlWriter = message.getContent(XMLStreamWriter.class);
            SOAPMessage soapMessage = message.getContent(SOAPMessage.class);
            Source source = message.getContent(Source.class);
            DataSource dataSource = message.getContent(DataSource.class);
            try {
                if (xmlWriter != null) {
                    xmlWriter.flush();
                } else if (soapMessage != null) {
                    Map heads = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
                    if (heads == null) {
                        heads = new HashMap();
                        message.put(Message.PROTOCOL_HEADERS, heads);
                    }
                    soapMessage.saveChanges();
                    Iterator smh = CastUtils.cast(soapMessage.getMimeHeaders().getAllHeaders());
                    while (smh.hasNext()) {
                        MimeHeader head = (MimeHeader)smh.next();
                        if ("Content-Type".equals(head.getName())) {
                            message.put("Content-Type", head.getValue());
                            continue;
                        }
                        if ("Content-Length".equals(head.getName())) continue;
                        if (!heads.containsKey(head.getName())) {
                            heads.put(head.getName(), new ArrayList());
                        }
                        List l = (List)heads.get(head.getName());
                        l.add(head.getValue());
                    }
                    OutputStream os = message.getContent(OutputStream.class);
                    soapMessage.writeTo(os);
                    os.flush();
                } else if (source != null) {
                    if (message.getAttachments() != null && !message.getAttachments().isEmpty()) {
                        message.put("write.attachments", Boolean.TRUE);
                        new AttachmentOutInterceptor().handleMessage(message);
                    }
                    OutputStream os = message.getContent(OutputStream.class);
                    DispatchOutDatabindingInterceptor.this.doTransform(source, os);
                    os.flush();
                } else if (dataSource != null) {
                    if (message.getAttachments() != null && !message.getAttachments().isEmpty()) {
                        message.put("write.attachments", Boolean.TRUE);
                        new AttachmentOutInterceptor().handleMessage(message);
                    }
                    message.put("Content-Type", dataSource.getContentType());
                    OutputStream os = message.getContent(OutputStream.class);
                    DispatchOutDatabindingInterceptor.this.doTransform(dataSource, os);
                    os.flush();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Fault(new org.apache.cxf.common.i18n.Message("EXCEPTION_WRITING_OBJECT", LOG, ex));
            }
        }
    }
}

