/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.xbean;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jbi.management.DeploymentException;
import org.apache.servicemix.common.AbstractDeployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointComponentContext;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.xbean.ClassLoaderXmlPreprocessor;
import org.apache.servicemix.common.xbean.ParentBeanFactoryPostProcessor;
import org.apache.servicemix.common.xbean.XBeanServiceUnit;
import org.apache.xbean.spring.context.FileSystemXmlApplicationContext;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractXBeanDeployer
extends AbstractDeployer {
    public AbstractXBeanDeployer(ServiceMixComponent component) {
        super(component);
    }

    protected String getXBeanFile() {
        return "xbean";
    }

    @Override
    public boolean canDeploy(String serviceUnitName, String serviceUnitRootPath) {
        File xbean = new File(serviceUnitRootPath, this.getXBeanFile() + ".xml");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for " + xbean + ": " + xbean.exists()));
        }
        return xbean.exists();
    }

    @Override
    public ServiceUnit deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        FileSystemXmlApplicationContext applicationContext = null;
        try {
            XBeanServiceUnit su = new XBeanServiceUnit();
            su.setComponent(this.component);
            su.setName(serviceUnitName);
            su.setRootPath(serviceUnitRootPath);
            ClassLoader classLoader = this.component.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            File baseDir = new File(serviceUnitRootPath);
            String location = this.getXBeanFile();
            applicationContext = this.createApplicationContext(serviceUnitRootPath);
            for (BeanFactoryPostProcessor processor : this.getBeanFactoryPostProcessors(serviceUnitRootPath)) {
                applicationContext.addBeanFactoryPostProcessor(processor);
            }
            applicationContext.refresh();
            su.setApplicationContext((AbstractXmlApplicationContext)applicationContext);
            Thread.currentThread().setContextClassLoader(su.getConfigurationClassLoader());
            this.initApplicationContext((AbstractXmlApplicationContext)applicationContext);
            Collection<Endpoint> endpoints = this.getServices((AbstractXmlApplicationContext)applicationContext);
            for (Endpoint endpoint : endpoints) {
                endpoint.setServiceUnit(su);
                this.validate(endpoint);
                su.addEndpoint(endpoint);
            }
            this.validate(su);
            XBeanServiceUnit xBeanServiceUnit = su;
            return xBeanServiceUnit;
        }
        catch (Throwable e) {
            this.logger.error((Object)e);
            if (applicationContext != null) {
                try {
                    applicationContext.destroy();
                }
                catch (Exception ne) {
                    this.logger.error((Object)ne);
                }
            }
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw this.failure("deploy", "Could not deploy xbean service unit", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
    }

    protected void initApplicationContext(AbstractXmlApplicationContext applicationContext) throws Exception {
    }

    protected Collection<Endpoint> getServices(AbstractXmlApplicationContext applicationContext) throws Exception {
        return applicationContext.getBeansOfType(Endpoint.class).values();
    }

    protected FileSystemXmlApplicationContext createApplicationContext(String serviceUnitRootPath) {
        File baseDir = new File(serviceUnitRootPath);
        String location = this.getXBeanFile();
        return new FileSystemXmlApplicationContext(new String[]{"/" + baseDir.toURI().resolve(location).getPath() + ".xml"}, false, this.getXmlPreProcessors(serviceUnitRootPath));
    }

    protected List getXmlPreProcessors(String serviceUnitRootPath) {
        ClassLoaderXmlPreprocessor classLoaderXmlPreprocessor = new ClassLoaderXmlPreprocessor(new File(serviceUnitRootPath), this.component);
        return Collections.singletonList(classLoaderXmlPreprocessor);
    }

    protected List getBeanFactoryPostProcessors(String serviceUnitRootPath) {
        Map beans;
        ArrayList<Object> processors = new ArrayList<Object>();
        PropertyPlaceholderConfigurer propertyPlaceholder = new PropertyPlaceholderConfigurer();
        FileSystemResource propertiesFile = new FileSystemResource(new File(serviceUnitRootPath) + "/" + this.getXBeanFile() + ".properties");
        if (propertiesFile.getFile().exists()) {
            propertyPlaceholder.setLocation((Resource)propertiesFile);
            processors.add(propertyPlaceholder);
        }
        if ((beans = this.getParentBeansMap()) != null) {
            processors.add(new ParentBeanFactoryPostProcessor(beans));
        }
        return processors;
    }

    protected Map getParentBeansMap() {
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("context", new EndpointComponentContext(this.component.getComponentContext()));
        beans.put("component", this.component);
        Object smx3 = this.component.getSmx3Container();
        if (smx3 != null) {
            beans.put("container", smx3);
        }
        return beans;
    }
}

