/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.component;

import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.wsn.client.AbstractWSAClient;
import org.apache.servicemix.wsn.component.WSNDeployableEndpoint;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.b_2.SubscribeResponse;

public class WSNSubscriptionEndpoint
extends WSNDeployableEndpoint {
    private Subscribe request;
    private SubscribeResponse response;

    public WSNSubscriptionEndpoint(Subscribe request) throws DeploymentException {
        this(request, null, null);
    }

    public WSNSubscriptionEndpoint(Subscribe request, QName service, String endpoint) {
        this.request = request;
        this.service = service != null ? service : new QName("http://servicemix.org/wsnotification", "Subscription");
        this.endpoint = endpoint != null ? endpoint : new IdGenerator().generateSanitizedId();
    }

    public MessageExchange.Role getRole() {
        return MessageExchange.Role.CONSUMER;
    }

    public void activate() throws Exception {
        this.response = this.getNotificationBroker().handleSubscribe(this.request, this);
    }

    public void deactivate() throws Exception {
        this.getNotificationBroker().unsubscribe(AbstractWSAClient.getWSAAddress(this.response.getSubscriptionReference()));
    }
}

