/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;

public class PaxLoggerImpl
implements PaxLogger {
    private Logger m_delegate;
    private String m_fqcn;
    private Bundle m_bundle;
    private PaxLoggingServiceImpl m_service;

    PaxLoggerImpl(Bundle bundle, Logger delegate, String fqcn, PaxLoggingServiceImpl service) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isEnabledFor(Level.WARN);
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isEnabledFor(Level.FATAL);
    }

    public void trace(String message, Throwable t) {
        this.m_delegate.log(this.m_fqcn, Level.TRACE, message, t);
        this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
    }

    public void debug(String message, Throwable t) {
        this.m_delegate.log(this.m_fqcn, Level.DEBUG, message, t);
        this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
    }

    public void inform(String message, Throwable t) {
        this.m_delegate.log(this.m_fqcn, Level.INFO, message, t);
        this.m_service.handleEvents(this.m_bundle, null, 3, message, t);
    }

    public void warn(String message, Throwable t) {
        this.m_delegate.log(this.m_fqcn, Level.WARN, message, t);
        this.m_service.handleEvents(this.m_bundle, null, 2, message, t);
    }

    public void error(String message, Throwable t) {
        this.m_delegate.log(this.m_fqcn, Level.ERROR, message, t);
        this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
    }

    public void fatal(String message, Throwable t) {
        this.m_delegate.log(this.m_fqcn, Level.FATAL, message, t);
        this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
    }

    public int getLogLevel() {
        return this.m_delegate.getLevel().toInt();
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public void log(String callerFQCN, Priority level, Object message, Throwable t) {
        if (callerFQCN == null) {
            callerFQCN = this.m_fqcn;
        }
        this.m_delegate.log(callerFQCN, level, message, t);
    }
}

