/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ValidationHelper;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.util.Validatable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class ResultDescriptor
extends AbstractDescriptor
implements Validatable {
    protected List postFunctions = new ArrayList();
    protected List preFunctions = new ArrayList();
    protected List validators = new ArrayList();
    protected String dueDate;
    protected String oldStatus;
    protected String owner;
    protected String status;
    protected boolean hasStep = false;
    protected int join;
    protected int split;
    protected int step = 0;

    public ResultDescriptor() {
    }

    public ResultDescriptor(Element result) {
        this.init(result);
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public void setJoin(int join) {
        this.join = join;
    }

    public int getJoin() {
        return this.join;
    }

    public void setOldStatus(String oldStatus) {
        this.oldStatus = oldStatus;
    }

    public String getOldStatus() {
        return this.oldStatus;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public List getPostFunctions() {
        return this.postFunctions;
    }

    public List getPreFunctions() {
        return this.preFunctions;
    }

    public void setSplit(int split) {
        this.split = split;
    }

    public int getSplit() {
        return this.split;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStep(int step) {
        this.step = step;
        this.hasStep = true;
    }

    public int getStep() {
        return this.step;
    }

    public List getValidators() {
        return this.validators;
    }

    public void validate() throws InvalidWorkflowDescriptorException {
        ValidationHelper.validate(this.preFunctions);
        ValidationHelper.validate(this.postFunctions);
        ValidationHelper.validate(this.validators);
        if (this.split == 0 && this.join == 0) {
            StringBuffer error = new StringBuffer("Result ");
            if (this.getId() > 0) {
                error.append("#").append(this.getId());
            }
            error.append(" is not a split or join, and has no ");
            if (!this.hasStep) {
                throw new InvalidWorkflowDescriptorException(error.append("next step").toString());
            }
            if (this.status == null || this.status.length() == 0) {
                throw new InvalidWorkflowDescriptorException(error.append("status").toString());
            }
        }
    }

    public void writeXML(PrintWriter out, int indent) {
        XMLUtil.printIndent(out, indent++);
        StringBuffer buf = new StringBuffer();
        buf.append("<unconditional-result");
        if (this.hasId()) {
            buf.append(" id=\"").append(this.getId()).append("\"");
        }
        buf.append(" old-status=\"").append(this.oldStatus).append("\"");
        if (this.join != 0) {
            buf.append(" join=\"").append(this.join).append("\"");
        } else if (this.split != 0) {
            buf.append(" split=\"").append(this.split).append("\"");
        } else {
            buf.append(" status=\"").append(this.status).append("\"");
            buf.append(" step=\"").append(this.step).append("\"");
            if (this.owner != null && this.owner.length() > 0) {
                buf.append(" owner=\"").append(this.owner).append("\"");
            }
        }
        if (this.preFunctions.size() == 0 && this.postFunctions.size() == 0) {
            buf.append("/>");
            out.println(buf.toString());
        } else {
            buf.append(">");
            out.println(buf.toString());
            this.printPreFunctions(out, indent);
            this.printPostFunctions(out, indent);
            XMLUtil.printIndent(out, --indent);
            out.println("</unconditional-result>");
        }
    }

    protected void init(Element result) {
        Element post;
        Element pre;
        this.oldStatus = result.getAttribute("old-status");
        this.status = result.getAttribute("status");
        try {
            this.setId(Integer.parseInt(result.getAttribute("id")));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.dueDate = result.getAttribute("due-date");
        try {
            this.split = Integer.parseInt(result.getAttribute("split"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.join = Integer.parseInt(result.getAttribute("join"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.step = Integer.parseInt(result.getAttribute("step"));
            this.hasStep = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.owner = result.getAttribute("owner");
        Element v = XMLUtil.getChildElement(result, "validators");
        if (v != null) {
            List validators = XMLUtil.getChildElements(v, "validator");
            for (int k = 0; k < validators.size(); ++k) {
                Element validator = (Element)validators.get(k);
                ValidatorDescriptor validatorDescriptor = new ValidatorDescriptor(validator);
                validatorDescriptor.setParent(this);
                this.validators.add(validatorDescriptor);
            }
        }
        if ((pre = XMLUtil.getChildElement(result, "pre-functions")) != null) {
            List preFunctions = XMLUtil.getChildElements(pre, "function");
            for (int k = 0; k < preFunctions.size(); ++k) {
                Element preFunction = (Element)preFunctions.get(k);
                FunctionDescriptor functionDescriptor = new FunctionDescriptor(preFunction);
                functionDescriptor.setParent(this);
                this.preFunctions.add(functionDescriptor);
            }
        }
        if ((post = XMLUtil.getChildElement(result, "post-functions")) != null) {
            List postFunctions = XMLUtil.getChildElements(post, "function");
            for (int k = 0; k < postFunctions.size(); ++k) {
                Element postFunction = (Element)postFunctions.get(k);
                FunctionDescriptor functionDescriptor = new FunctionDescriptor(postFunction);
                functionDescriptor.setParent(this);
                this.postFunctions.add(functionDescriptor);
            }
        }
    }

    protected void printPostFunctions(PrintWriter out, int indent) {
        if (this.postFunctions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<post-functions>");
            Iterator iter = this.postFunctions.iterator();
            while (iter.hasNext()) {
                FunctionDescriptor function = (FunctionDescriptor)iter.next();
                function.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</post-functions>");
        }
    }

    protected void printPreFunctions(PrintWriter out, int indent) {
        if (this.preFunctions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<pre-functions>");
            Iterator iter = this.preFunctions.iterator();
            while (iter.hasNext()) {
                FunctionDescriptor function = (FunctionDescriptor)iter.next();
                function.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</pre-functions>");
        }
    }
}

