/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.servicemix.camel.CamelJbiComponent;
import org.apache.servicemix.camel.CamelSpringDeployer;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.xbean.ClassLoaderXmlPreprocessor;
import org.apache.xbean.classloader.JarFileClassLoader;
import org.apache.xbean.spring.context.SpringApplicationContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

public class CamelComponentFactoryBean
implements FactoryBean,
BundleContextAware,
InitializingBean {
    private BundleContext bundleContext;
    private CamelJbiComponent component;

    public Object getObject() throws Exception {
        return this.component;
    }

    public Class getObjectType() {
        return CamelJbiComponent.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        try {
            Enumeration e = this.bundleContext.getBundle().getResources("META-INF/spring.handlers");
            while (e.hasMoreElements()) {
                System.err.println(e.nextElement());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.component = new OsgiCamelJbiComponent();
    }

    public class OsgiClassLoaderXmlPreprocessor
    extends ClassLoaderXmlPreprocessor {
        public OsgiClassLoaderXmlPreprocessor(File root, ServiceMixComponent component) {
            super(root, component);
        }

        protected ClassLoader getParentClassLoader(SpringApplicationContext applicationContext) {
            ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>();
            parents.add(super.getParentClassLoader(applicationContext));
            for (Bundle bundle : CamelComponentFactoryBean.this.bundleContext.getBundles()) {
                try {
                    if (!bundle.getSymbolicName().contains("camel-spring")) continue;
                    parents.add((ClassLoader)BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)bundle));
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            return new JarFileClassLoader("SU parent class loader", new URL[0], parents.toArray(new ClassLoader[parents.size()]));
        }
    }

    public class OsgiCamelSpringDeployer
    extends CamelSpringDeployer {
        public OsgiCamelSpringDeployer(CamelJbiComponent component) {
            super(component);
        }

        protected List getXmlPreProcessors(String serviceUnitRootPath) {
            OsgiClassLoaderXmlPreprocessor classLoaderXmlPreprocessor = new OsgiClassLoaderXmlPreprocessor(new File(serviceUnitRootPath), (ServiceMixComponent)CamelComponentFactoryBean.this.component);
            return Collections.singletonList(classLoaderXmlPreprocessor);
        }
    }

    public class OsgiCamelJbiComponent
    extends CamelJbiComponent {
        public BaseServiceUnitManager createServiceUnitManager() {
            OsgiCamelSpringDeployer deployer = new OsgiCamelSpringDeployer(this);
            return new BaseServiceUnitManager((ServiceMixComponent)this, new Deployer[]{deployer});
        }
    }
}

