/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.client.HttpEventListener;

public class HttpEventListenerWrapper
implements HttpEventListener {
    HttpEventListener _listener;
    boolean _delegating;

    public HttpEventListenerWrapper() {
        this._listener = null;
        this._delegating = false;
    }

    public HttpEventListenerWrapper(HttpEventListener eventListener, boolean delegating) {
        this._listener = eventListener;
        this._delegating = delegating;
    }

    public HttpEventListener getEventListener() {
        return this._listener;
    }

    public void setEventListener(HttpEventListener listener) {
        this._listener = listener;
    }

    public boolean isDelegating() {
        return this._delegating;
    }

    public void setDelegating(boolean delegating) {
        this._delegating = delegating;
    }

    public void onConnectionFailed(Throwable ex) {
        if (this._delegating) {
            this._listener.onConnectionFailed(ex);
        }
    }

    public void onException(Throwable ex) {
        if (this._delegating) {
            this._listener.onException(ex);
        }
    }

    public void onExpire() {
        if (this._delegating) {
            this._listener.onExpire();
        }
    }

    public void onRequestCommitted() throws IOException {
        if (this._delegating) {
            this._listener.onRequestCommitted();
        }
    }

    public void onRequestComplete() throws IOException {
        if (this._delegating) {
            this._listener.onRequestComplete();
        }
    }

    public void onResponseComplete() throws IOException {
        if (this._delegating) {
            this._listener.onResponseComplete();
        }
    }

    public void onResponseContent(Buffer content) throws IOException {
        if (this._delegating) {
            this._listener.onResponseContent(content);
        }
    }

    public void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (this._delegating) {
            this._listener.onResponseHeader(name, value);
        }
    }

    public void onResponseHeaderComplete() throws IOException {
        if (this._delegating) {
            this._listener.onResponseHeaderComplete();
        }
    }

    public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        if (this._delegating) {
            this._listener.onResponseStatus(version, status, reason);
        }
    }

    public void onRetry() {
        if (this._delegating) {
            this._listener.onRetry();
        }
    }
}

