/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client.security;

import java.io.IOException;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.jetty.client.security.Authorization;
import org.mortbay.jetty.client.security.Realm;
import org.mortbay.jetty.security.B64Code;
import org.mortbay.util.StringUtil;

public class BasicAuthorization
implements Authorization {
    private Buffer _authorization;

    public BasicAuthorization(Realm realm) throws IOException {
        String authenticationString = "basic " + B64Code.encode(realm.getPrincipal() + ":" + realm.getCredentials(), StringUtil.__ISO_8859_1);
        this._authorization = new ByteArrayBuffer(authenticationString);
    }

    public void setCredentials(HttpExchange exchange) throws IOException {
        exchange.setRequestHeader(HttpHeaders.AUTHORIZATION_BUFFER, this._authorization);
    }
}

