/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.log.Log;
import org.mortbay.thread.ThreadPool;

public class QueuedThreadPool
extends AbstractLifeCycle
implements Serializable,
ThreadPool {
    private static int __id;
    private String _name;
    private Set _threads;
    private List _idle;
    private Runnable[] _jobs;
    private int _nextJob;
    private int _nextJobSlot;
    private int _queued;
    private boolean _daemon;
    private int _id;
    private final Object _threadLock = new Lock();
    private final Object _idleLock = new Lock();
    private final Object _jobsLock = new Lock();
    private final Object _joinLock = new Lock();
    private long _lastShrink;
    private int _maxIdleTimeMs = 60000;
    private int _maxThreads = 25;
    private int _minThreads = 2;
    private boolean _warned = false;
    private int _lowThreads = 0;
    private int _priority = 5;
    private int _spawnOrShrinkAt = 0;

    public QueuedThreadPool() {
        this._name = "qtp" + __id++;
    }

    public QueuedThreadPool(int maxThreads) {
        this();
        this.setMaxThreads(maxThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(Runnable job) {
        if (!this.isRunning() || job == null) {
            return false;
        }
        PoolThread thread = null;
        boolean spawn = false;
        Object object = this._idleLock;
        synchronized (object) {
            int idle = this._idle.size();
            if (idle > 0) {
                thread = (PoolThread)this._idle.remove(idle - 1);
            } else if (this._threads.size() < this._maxThreads) {
                spawn = true;
            } else if (!this._warned) {
                this._warned = true;
                Log.debug("Out of threads for {}", this);
            }
        }
        if (thread != null) {
            thread.dispatch(job);
        } else {
            object = this._jobsLock;
            synchronized (object) {
                ++this._queued;
                this._jobs[this._nextJobSlot++] = job;
                if (this._nextJobSlot == this._jobs.length) {
                    this._nextJobSlot = 0;
                }
                if (this._nextJobSlot == this._nextJob) {
                    Runnable[] jobs = new Runnable[this._jobs.length + this._maxThreads];
                    int split = this._jobs.length - this._nextJob;
                    if (split > 0) {
                        System.arraycopy(this._jobs, this._nextJob, jobs, 0, split);
                    }
                    if (this._nextJob != 0) {
                        System.arraycopy(this._jobs, 0, jobs, split, this._nextJobSlot);
                    }
                    this._jobs = jobs;
                    this._nextJob = 0;
                    this._nextJobSlot = this._queued;
                }
                if (spawn && this._queued <= this._spawnOrShrinkAt) {
                    spawn = false;
                }
            }
            if (spawn) {
                this.newThread();
            }
        }
        return true;
    }

    public int getIdleThreads() {
        return this._idle == null ? 0 : this._idle.size();
    }

    public int getLowThreads() {
        return this._lowThreads;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    public int getThreads() {
        return this._threads.size();
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public int getQueueSize() {
        return this._queued;
    }

    public int getSpawnOrShrinkAt() {
        return this._spawnOrShrinkAt;
    }

    public void setSpawnOrShrinkAt(int spawnOrShrinkAt) {
        this._spawnOrShrinkAt = spawnOrShrinkAt;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    public boolean isLowOnThreads() {
        return this._queued > this._lowThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(100L);
        }
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setLowThreads(int lowThreads) {
        this._lowThreads = lowThreads;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public void setMaxThreads(int maxThreads) {
        if (this.isStarted() && maxThreads < this._minThreads) {
            throw new IllegalArgumentException("!minThreads<maxThreads");
        }
        this._maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinThreads(int minThreads) {
        if (this.isStarted() && (minThreads <= 0 || minThreads > this._maxThreads)) {
            throw new IllegalArgumentException("!0<=minThreads<maxThreads");
        }
        this._minThreads = minThreads;
        Object object = this._threadLock;
        synchronized (object) {
            while (this.isStarted() && this._threads.size() < this._minThreads) {
                this.newThread();
            }
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    protected void doStart() throws Exception {
        if (this._maxThreads < this._minThreads || this._minThreads <= 0) {
            throw new IllegalArgumentException("!0<minThreads<maxThreads");
        }
        this._threads = new HashSet();
        this._idle = new ArrayList();
        this._jobs = new Runnable[this._maxThreads];
        for (int i = 0; i < this._minThreads; ++i) {
            this.newThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        for (int i = 0; i < 100; ++i) {
            Object object = this._threadLock;
            synchronized (object) {
                Iterator iter = this._threads.iterator();
                while (iter.hasNext()) {
                    ((Thread)iter.next()).interrupt();
                }
            }
            Thread.yield();
            if (this._threads.size() == 0) break;
            try {
                Thread.sleep(i * 100);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this._threads.size() > 0) {
            Log.warn(this._threads.size() + " threads could not be stopped");
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newThread() {
        Object object = this._threadLock;
        synchronized (object) {
            PoolThread thread = new PoolThread();
            this._threads.add(thread);
            thread.setName(this._name + "-" + this._id++);
            thread.start();
        }
    }

    protected void stopJob(Thread thread, Object job) {
        thread.interrupt();
    }

    private class Lock {
        private Lock() {
        }
    }

    public class PoolThread
    extends Thread {
        Runnable _job = null;
        boolean _isIdle = false;

        PoolThread() {
            this.setDaemon(QueuedThreadPool.this._daemon);
            this.setPriority(QueuedThreadPool.this._priority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block32: {
                block31: {
                    try {
                        Object job = null;
                        while (QueuedThreadPool.this.isRunning()) {
                            Object todo;
                            if (job != null) {
                                this._isIdle = false;
                                todo = job;
                                job = null;
                                todo.run();
                                continue;
                            }
                            todo = QueuedThreadPool.this._jobsLock;
                            synchronized (todo) {
                                if (QueuedThreadPool.this._queued > 0) {
                                    QueuedThreadPool.this._queued--;
                                    job = QueuedThreadPool.this._jobs[QueuedThreadPool.this._nextJob++];
                                    if (QueuedThreadPool.this._nextJob == QueuedThreadPool.this._jobs.length) {
                                        QueuedThreadPool.this._nextJob = 0;
                                    }
                                    continue;
                                }
                            }
                            todo = QueuedThreadPool.this._idleLock;
                            synchronized (todo) {
                                QueuedThreadPool.this._warned = false;
                                if (QueuedThreadPool.this._threads.size() > QueuedThreadPool.this._maxThreads || QueuedThreadPool.this._idle.size() > QueuedThreadPool.this._spawnOrShrinkAt && QueuedThreadPool.this._threads.size() > QueuedThreadPool.this._minThreads) {
                                    this._isIdle = QueuedThreadPool.this._idle.contains(this);
                                    long now = System.currentTimeMillis();
                                    if (this._isIdle && now - QueuedThreadPool.this._lastShrink > (long)QueuedThreadPool.this.getMaxIdleTimeMs()) {
                                        QueuedThreadPool.this._lastShrink = now;
                                        // MONITOREXIT @DISABLED, blocks:[0, 23, 29, 13, 30] lbl32 : MonitorExitStatement: MONITOREXIT : todo
                                        Object var8_5 = null;
                                        break block31;
                                    }
                                }
                                if (!this._isIdle) {
                                    QueuedThreadPool.this._idle.add(this);
                                    this._isIdle = true;
                                }
                            }
                            try {
                                todo = this;
                                synchronized (todo) {
                                    if (this._job == null) {
                                        this.wait(QueuedThreadPool.this.getMaxIdleTimeMs());
                                    }
                                    job = this._job;
                                    this._job = null;
                                }
                            }
                            catch (InterruptedException e) {
                                Log.ignore(e);
                            }
                        }
                        break block32;
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        Object object = QueuedThreadPool.this._idleLock;
                        synchronized (object) {
                            QueuedThreadPool.this._idle.remove(this);
                        }
                        object = QueuedThreadPool.this._threadLock;
                        synchronized (object) {
                            QueuedThreadPool.this._threads.remove(this);
                        }
                        Runnable job = null;
                        PoolThread poolThread = this;
                        synchronized (poolThread) {
                            job = this._job;
                        }
                        if (job == null) throw throwable;
                        if (!QueuedThreadPool.this.isRunning()) throw throwable;
                        QueuedThreadPool.this.dispatch(job);
                        throw throwable;
                    }
                }
                Object object = QueuedThreadPool.this._idleLock;
                synchronized (object) {
                    QueuedThreadPool.this._idle.remove(this);
                }
                object = QueuedThreadPool.this._threadLock;
                synchronized (object) {
                    QueuedThreadPool.this._threads.remove(this);
                }
                Runnable job = null;
                PoolThread poolThread = this;
                synchronized (poolThread) {
                    job = this._job;
                }
                if (job == null) return;
                if (!QueuedThreadPool.this.isRunning()) return;
                QueuedThreadPool.this.dispatch(job);
                return;
            }
            Object var8_6 = null;
            Object object = QueuedThreadPool.this._idleLock;
            synchronized (object) {
                QueuedThreadPool.this._idle.remove(this);
            }
            object = QueuedThreadPool.this._threadLock;
            synchronized (object) {
                QueuedThreadPool.this._threads.remove(this);
            }
            Runnable job = null;
            PoolThread poolThread = this;
            synchronized (poolThread) {
                job = this._job;
            }
            if (job == null) return;
            if (!QueuedThreadPool.this.isRunning()) return;
            QueuedThreadPool.this.dispatch(job);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(Runnable job) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                if (this._job != null || job == null) {
                    throw new IllegalStateException();
                }
                this._job = job;
                this.notify();
            }
        }
    }
}

