/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.gshell.log;

import java.util.Dictionary;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@CommandComponent(id="log:set", description="Change the log level")
public class SetLogLevel
extends OsgiCommandSupport {
    @Argument(index=0, required=true, description="Level (TRACE, DEBUG, INFO, WARN, ERROR or - to unset")
    String level;
    @Argument(index=1, required=false, description="Logger name or ROOT (default)")
    String logger;
    static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    static final String LOGGER_PREFIX = "log4j.logger.";
    static final String ROOT_LOGGER = "ROOT";
    static final String TRACE = "TRACE";
    static final String DEBUG = "DEBUG";
    static final String INFO = "INFO";
    static final String WARN = "WARN";
    static final String ERROR = "ERROR";
    static final String INHERITED = "-";

    protected Object doExecute() throws Exception {
        if (ROOT_LOGGER.equalsIgnoreCase(this.logger)) {
            this.logger = null;
        }
        if (!(TRACE.equals(this.level) || DEBUG.equals(this.level) || INFO.equals(this.level) || WARN.equals(this.level) || ERROR.equals(this.level) || INHERITED.equals(this.level))) {
            this.io.err.println("level must be set to TRACE, DEBUG, INFO, WARN or ERROR (or - to unset it)");
            return FAILURE;
        }
        if (INHERITED.equals(this.level) && this.logger == null) {
            this.io.err.println("Can not unset the ROOT logger");
            return FAILURE;
        }
        ConfigurationAdmin cfgAdmin = this.getConfigAdmin();
        Configuration cfg = cfgAdmin.getConfiguration(CONFIGURATION_PID, null);
        Dictionary props = cfg.getProperties();
        String logger = this.logger;
        String prop = logger == null ? ROOT_LOGGER_PREFIX : LOGGER_PREFIX + logger;
        String val = (String)props.get(prop);
        if (INHERITED.equals(this.level)) {
            if (val != null) {
                int idx = (val = val.trim()).indexOf(",");
                val = idx > 0 ? val.substring(idx) : null;
            }
        } else if (val == null) {
            val = this.level;
        } else {
            int idx = (val = val.trim()).indexOf(",");
            if (idx == 0) {
                val = this.level + val;
            } else if (idx > 0) {
                val = this.level + val.substring(idx);
            }
        }
        if (val == null) {
            props.remove(prop);
        } else {
            props.put(prop, val);
        }
        cfg.update(props);
        return SUCCESS;
    }

    protected ConfigurationAdmin getConfigAdmin() {
        ServiceReference ref = this.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        return (ConfigurationAdmin)this.getService(ConfigurationAdmin.class, ref);
    }
}

