/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.gshell.log;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.TreeMap;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@CommandComponent(id="log:get", description="Show Log Level")
public class GetLogLevel
extends OsgiCommandSupport {
    @Argument(required=false, description="Logger name, ALL or ROOT (default)")
    String logger;
    static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    static final String LOGGER_PREFIX = "log4j.logger.";
    static final String ALL_LOGGER = "ALL";
    static final String ROOT_LOGGER = "ROOT";

    protected Object doExecute() throws Exception {
        ConfigurationAdmin cfgAdmin = this.getConfigAdmin();
        Configuration cfg = cfgAdmin.getConfiguration(CONFIGURATION_PID, null);
        Dictionary props = cfg.getProperties();
        if (ROOT_LOGGER.equalsIgnoreCase(this.logger)) {
            this.logger = null;
        }
        if (ALL_LOGGER.equalsIgnoreCase(this.logger)) {
            String root = this.getLevel((String)props.get(ROOT_LOGGER_PREFIX));
            TreeMap<String, String> loggers = new TreeMap<String, String>();
            Enumeration e = props.keys();
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                if (!prop.startsWith(LOGGER_PREFIX)) continue;
                String val = this.getLevel((String)props.get(prop));
                loggers.put(prop.substring(LOGGER_PREFIX.length()), val);
            }
            this.io.out.println("ROOT: " + root);
            for (String logger : loggers.keySet()) {
                this.io.out.println(logger + ": " + (String)loggers.get(logger));
            }
        } else {
            String val;
            String logger = this.logger;
            while (true) {
                String prop = logger == null ? ROOT_LOGGER_PREFIX : LOGGER_PREFIX + logger;
                val = (String)props.get(prop);
                if ((val = this.getLevel(val)) != null || logger == null) break;
                int idx = logger.lastIndexOf(46);
                if (idx < 0) {
                    logger = null;
                    continue;
                }
                logger = logger.substring(0, idx);
            }
            String st = "Level: " + val;
            if (logger != this.logger) {
                st = st + " (inherited from " + (logger != null ? logger : ROOT_LOGGER) + ")";
            }
            this.io.out.println(st);
        }
        return SUCCESS;
    }

    protected String getLevel(String prop) {
        if (prop == null) {
            return null;
        }
        String val = prop.trim();
        int idx = val.indexOf(",");
        if (idx == 0) {
            val = null;
        } else if (idx > 0) {
            val = val.substring(0, idx);
        }
        return val;
    }

    protected ConfigurationAdmin getConfigAdmin() {
        ServiceReference ref = this.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        return (ConfigurationAdmin)this.getService(ConfigurationAdmin.class, ref);
    }
}

