/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.filter;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.activemq.console.filter.QueryFilter;
import org.apache.activemq.console.filter.RegExQueryFilter;

public class MBeansRegExQueryFilter
extends RegExQueryFilter {
    public MBeansRegExQueryFilter(QueryFilter next) {
        super(next);
    }

    protected boolean matches(Object data, Map regex) throws Exception {
        try {
            Method method = this.getClass().getDeclaredMethod("matches", data.getClass(), Map.class);
            return (Boolean)method.invoke((Object)this, data, regex);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    protected boolean matches(ObjectInstance data, Map regex) {
        return this.matches(data.getObjectName(), regex);
    }

    protected boolean matches(ObjectName data, Map regex) {
        for (String key : regex.keySet()) {
            String target = data.getKeyProperty(key);
            if (target == null || ((Pattern)regex.get(key)).matcher(target).matches()) continue;
            return false;
        }
        return true;
    }

    protected boolean matches(AttributeList data, Map regex) {
        for (String key : regex.keySet()) {
            Iterator j = data.iterator();
            if (!j.hasNext()) continue;
            Attribute attrib = (Attribute)j.next();
            if (attrib.getName().equals("Attribute:ObjectName:")) {
                String target = ((ObjectName)attrib.getValue()).getKeyProperty(key);
                if (target != null && ((Pattern)regex.get(key)).matcher(target).matches()) continue;
                return false;
            }
            if (attrib.getName().equals(key)) {
                if (((Pattern)regex.get(key)).matcher(attrib.getValue().toString()).matches()) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

