/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.scripting;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.common.util.URIResolver;
import org.apache.servicemix.scripting.DefaultScriptingMarshaler;
import org.apache.servicemix.scripting.ScriptingEndpointType;
import org.apache.servicemix.scripting.ScriptingMarshalerSupport;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingEndpoint
extends ProviderEndpoint
implements ScriptingEndpointType {
    public static final String KEY_CHANNEL = "deliveryChannel";
    public static final String KEY_COMPONENT_NAMESPACE = "componentNamespace";
    public static final String KEY_CONTEXT = "componentContext";
    public static final String KEY_ENDPOINT = "endpoint";
    public static final String KEY_ENDPOINTNAME = "endpointname";
    public static final String KEY_IN_EXCHANGE = "exchange";
    public static final String KEY_IN_MSG = "inMessage";
    public static final String KEY_OUT_EXCHANGE = "outExchange";
    public static final String KEY_OUT_MSG = "outMessage";
    public static final String KEY_INTERFACENAME = "interfacename";
    public static final String KEY_LOGGER = "log";
    public static final String KEY_SCRIPT = "script";
    public static final String KEY_SERVICENAME = "servicename";
    public static final String KEY_USER_BINDINGS = "bindings";
    public static final String LANGUAGE_AUTODETECT = "autodetect";
    private static Log logger = LogFactory.getLog(ScriptingEndpoint.class);
    private Map<String, Object> bindings;
    private boolean disableOutput;
    private boolean copyProperties;
    private boolean copyAttachments;
    private ScriptEngine engine;
    private String language = "autodetect";
    private String logResourceBundle;
    private ScriptEngineManager manager;
    private ScriptingMarshalerSupport marshaler = new DefaultScriptingMarshaler();
    private Resource script;
    private Logger scriptLogger;
    private CompiledScript compiledScript;
    private QName targetInterface;
    private QName targetOperation;
    private QName targetService;
    private String targetEndpoint;
    private String targetUri;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    public static final char EXTENSION_SEPARATOR = '.';

    protected Logger createScriptLogger() throws MessagingException {
        if (this.logResourceBundle != null) {
            try {
                return this.getContext().getLogger(this.getClass().getName(), this.logResourceBundle);
            }
            catch (JBIException e) {
                throw new MessagingException((Throwable)e);
            }
        }
        return Logger.getLogger(this.getClass().getName());
    }

    protected void done(MessageExchange messageExchange) throws MessagingException {
        super.done(messageExchange);
    }

    protected void fail(MessageExchange messageExchange, Exception e) throws MessagingException {
        super.fail(messageExchange, e);
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLogResourceBundle() {
        return this.logResourceBundle;
    }

    public ScriptingMarshalerSupport getMarshaler() {
        return this.marshaler;
    }

    public Resource getScript() {
        return this.script;
    }

    public Logger getScriptLogger() throws MessagingException {
        if (this.scriptLogger == null) {
            this.scriptLogger = this.createScriptLogger();
        }
        return this.scriptLogger;
    }

    public boolean isDisableOutput() {
        return this.disableOutput;
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange == null) {
            return;
        }
        if (exchange.getRole() == MessageExchange.Role.CONSUMER) {
            return;
        }
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                return;
            }
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                return;
            }
            if (exchange.getFault() != null) {
                this.done(exchange);
            } else {
                InOnly outExchange = null;
                NormalizedMessage outMsg = null;
                NormalizedMessage inMsg = exchange.getMessage("in");
                Bindings scriptBindings = this.engine.createBindings();
                scriptBindings.put(KEY_CONTEXT, (Object)this.getContext());
                scriptBindings.put(KEY_IN_EXCHANGE, (Object)exchange);
                scriptBindings.put(KEY_IN_MSG, (Object)inMsg);
                scriptBindings.put(KEY_ENDPOINT, (Object)this);
                scriptBindings.put(KEY_CHANNEL, (Object)this.getChannel());
                scriptBindings.put(KEY_ENDPOINTNAME, (Object)this.getEndpoint());
                scriptBindings.put(KEY_SERVICENAME, (Object)this.getService());
                scriptBindings.put(KEY_INTERFACENAME, (Object)this.getInterfaceName());
                scriptBindings.put(KEY_LOGGER, (Object)this.getScriptLogger());
                if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
                    outExchange = this.getExchangeFactory().createInOnlyExchange();
                    String processCorrelationId = (String)exchange.getProperty("org.apache.servicemix.correlationId");
                    if (processCorrelationId != null) {
                        outExchange.setProperty("org.apache.servicemix.correlationId", (Object)processCorrelationId);
                    }
                    outMsg = outExchange.createMessage();
                    outExchange.setMessage(outMsg, "in");
                    scriptBindings.put(KEY_OUT_EXCHANGE, (Object)outExchange);
                    scriptBindings.put(KEY_OUT_MSG, (Object)outMsg);
                } else {
                    outMsg = exchange.createMessage();
                    exchange.setMessage(outMsg, "out");
                    scriptBindings.put(KEY_OUT_EXCHANGE, (Object)exchange);
                    scriptBindings.put(KEY_OUT_MSG, (Object)outMsg);
                }
                try {
                    scriptBindings.put(KEY_SCRIPT, (Object)this.getScript().getFile().getAbsolutePath());
                }
                catch (IOException ioex) {
                    scriptBindings.put(KEY_SCRIPT, (Object)this.getScript());
                }
                scriptBindings.put(KEY_USER_BINDINGS, (Object)this.bindings);
                scriptBindings.put(KEY_COMPONENT_NAMESPACE, (Object)scriptBindings);
                this.marshaler.registerUserBeans(this, exchange, scriptBindings);
                InputStream is = null;
                try {
                    is = this.marshaler.getScriptCode(this, exchange);
                }
                catch (IOException ioex) {
                    logger.error((Object)("Unable to load script in marshaler: " + this.marshaler.getClass().getName()), (Throwable)ioex);
                }
                if (is != null) {
                    try {
                        this.engine.eval((Reader)new InputStreamReader(is), scriptBindings);
                    }
                    catch (ScriptException ex) {
                        logger.error((Object)("Error executing the script: " + ex.getFileName() + " at line: " + ex.getLineNumber() + " and column: " + ex.getColumnNumber()), (Throwable)ex);
                        throw ex;
                    }
                }
                try {
                    if (this.compiledScript == null && this.engine instanceof Compilable) {
                        this.compiledScript = ((Compilable)((Object)this.engine)).compile(new InputStreamReader(this.script.getInputStream()));
                    }
                    if (this.compiledScript != null) {
                        this.compiledScript.eval(scriptBindings);
                    } else {
                        this.engine.eval((Reader)new InputStreamReader(this.script.getInputStream()), scriptBindings);
                    }
                }
                catch (IOException ioex) {
                    logger.error((Object)("Unable to load the script " + this.script.getFilename()), (Throwable)ioex);
                    throw new MessagingException("Unable to load the script " + this.script.getFilename());
                }
                catch (ScriptException ex) {
                    logger.error((Object)("Error executing the script: " + ex.getFileName() + " at line: " + ex.getLineNumber() + " and column: " + ex.getColumnNumber()), (Throwable)ex);
                    throw ex;
                }
                if (!this.isDisableOutput()) {
                    boolean txSync;
                    boolean bl = txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
                    if (this.isCopyProperties()) {
                        this.copyProperties(inMsg, outMsg);
                    }
                    if (this.isCopyAttachments()) {
                        this.copyAttachments(inMsg, outMsg);
                    }
                    if (exchange instanceof InOut || exchange instanceof InOptionalOut) {
                        if (txSync) {
                            this.getChannel().sendSync(exchange);
                        } else {
                            this.getChannel().send(exchange);
                        }
                    } else {
                        this.configureTarget((MessageExchange)outExchange);
                        if (txSync) {
                            this.getChannel().sendSync((MessageExchange)outExchange);
                        } else {
                            this.getChannel().send((MessageExchange)outExchange);
                        }
                        this.done(exchange);
                    }
                } else {
                    this.done(exchange);
                }
            }
        } else {
            throw new MessagingException("ScriptingEndpoint.process(): Unknown role: " + exchange.getRole());
        }
    }

    protected void send(MessageExchange messageExchange) throws MessagingException {
        super.send(messageExchange);
    }

    protected void sendSync(MessageExchange messageExchange) throws MessagingException {
        super.sendSync(messageExchange);
    }

    public void setBindings(Map<String, Object> bindings) {
        this.bindings = bindings;
    }

    public void setDisableOutput(boolean disableOutput) {
        this.disableOutput = disableOutput;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setLogResourceBundle(String logResourceBundle) {
        this.logResourceBundle = logResourceBundle;
    }

    public void setMarshaler(ScriptingMarshalerSupport marshaler) {
        this.marshaler = marshaler;
    }

    public void setScript(Resource script) {
        this.script = script;
    }

    public void setScriptLogger(Logger scriptLogger) {
        this.scriptLogger = scriptLogger;
    }

    public void start() throws Exception {
        super.start();
        try {
            this.manager = new ScriptEngineManager(this.serviceUnit.getConfigurationClassLoader());
            if (this.script == null) {
                throw new IllegalArgumentException("Property script must be set");
            }
            if (this.language.equalsIgnoreCase(LANGUAGE_AUTODETECT)) {
                this.engine = this.manager.getEngineByExtension(ScriptingEndpoint.getExtension(this.script.getFilename()));
                if (this.engine == null) {
                    throw new RuntimeException("There is no script engine registered for extension " + ScriptingEndpoint.getExtension(this.script.getFilename()));
                }
            } else {
                this.engine = this.manager.getEngineByName(this.language);
                if (this.engine == null) {
                    throw new RuntimeException("There is no script engine for language " + this.language);
                }
            }
            this.marshaler.onStartup(this);
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    public void stop() throws Exception {
        try {
            this.marshaler.onShutdown(this);
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        super.stop();
    }

    protected void copyProperties(NormalizedMessage from, NormalizedMessage to) {
        for (String propertyName : from.getPropertyNames()) {
            if (to.getProperty(propertyName) != null || "org.apache.servicemix.body".equals(propertyName)) continue;
            Object value = from.getProperty(propertyName);
            to.setProperty(propertyName, value);
        }
    }

    protected void copyAttachments(NormalizedMessage from, NormalizedMessage to) throws MessagingException {
        for (String attachmentName : from.getAttachmentNames()) {
            if (to.getAttachment(attachmentName) != null) continue;
            DataHandler value = from.getAttachment(attachmentName);
            to.addAttachment(attachmentName, value);
        }
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = ScriptingEndpoint.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = ScriptingEndpoint.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public void configureTarget(MessageExchange exchange) throws MessagingException {
        if (this.targetInterface == null && this.targetService == null && this.targetUri == null) {
            throw new MessagingException("target's interface, service or uri should be specified");
        }
        if (this.targetUri != null) {
            URIResolver.configureExchange((MessageExchange)exchange, (ComponentContext)this.getContext(), (String)this.targetUri);
        }
        if (this.targetInterface != null) {
            exchange.setInterfaceName(this.targetInterface);
        }
        if (this.targetOperation != null) {
            exchange.setOperation(this.targetOperation);
        }
        if (this.targetService != null) {
            exchange.setService(this.targetService);
            if (this.targetEndpoint != null) {
                ServiceEndpoint se = this.getContext().getEndpoint(this.targetService, this.targetEndpoint);
                exchange.setEndpoint(se);
            }
        }
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
    }

    public QName getTargetInterface() {
        return this.targetInterface;
    }

    public void setTargetInterface(QName targetInterface) {
        this.targetInterface = targetInterface;
    }

    public QName getTargetOperation() {
        return this.targetOperation;
    }

    public void setTargetOperation(QName targetOperation) {
        this.targetOperation = targetOperation;
    }

    public QName getTargetService() {
        return this.targetService;
    }

    public void setTargetService(QName targetService) {
        this.targetService = targetService;
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public void setTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
    }

    public String getTargetUri() {
        return this.targetUri;
    }

    public void setTargetUri(String targetUri) {
        this.targetUri = targetUri;
    }
}

