/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.xbean.spring.context.SpringApplicationContext;
import org.apache.xbean.spring.context.impl.XBeanHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.EntityResolver;

public class ResourceXmlApplicationContext
extends AbstractXmlApplicationContext
implements SpringApplicationContext {
    private final List xmlPreprocessors;
    private final Resource resource;

    public ResourceXmlApplicationContext(Resource resource) {
        this(resource, Collections.EMPTY_LIST);
    }

    public ResourceXmlApplicationContext(Resource resource, List xmlPreprocessors) {
        this.xmlPreprocessors = xmlPreprocessors;
        this.resource = resource;
        this.refresh();
    }

    public ResourceXmlApplicationContext(Resource resource, ApplicationContext parent) {
        this(resource, Collections.EMPTY_LIST, parent);
    }

    public ResourceXmlApplicationContext(Resource resource, List xmlPreprocessors, ApplicationContext parent) {
        this(resource, xmlPreprocessors, parent, Collections.EMPTY_LIST);
    }

    public ResourceXmlApplicationContext(Resource resource, List xmlPreprocessors, ApplicationContext parent, List beanPostProcessors) {
        this(resource, xmlPreprocessors, parent, beanPostProcessors, true);
    }

    public ResourceXmlApplicationContext(Resource resource, List xmlPreprocessors, ApplicationContext parent, List beanPostProcessors, boolean refresh) {
        super(parent);
        this.xmlPreprocessors = xmlPreprocessors;
        this.resource = resource;
        for (BeanFactoryPostProcessor processor : beanPostProcessors) {
            this.addBeanFactoryPostProcessor(processor);
        }
        if (refresh) {
            this.refresh();
        }
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        XmlBeanDefinitionReader beanDefinitionReader = XBeanHelper.createBeanDefinitionReader(this, (BeanDefinitionRegistry)beanFactory, this.xmlPreprocessors);
        beanDefinitionReader.setResourceLoader((ResourceLoader)this);
        beanDefinitionReader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)this));
        this.initBeanDefinitionReader(beanDefinitionReader);
        this.loadBeanDefinitions(beanDefinitionReader);
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        reader.loadBeanDefinitions(this.resource);
    }

    protected String[] getConfigLocations() {
        return null;
    }
}

