/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.File;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.mvn.internal.Configuration;
import org.ops4j.pax.url.mvn.internal.RepositoryURL;
import org.ops4j.pax.url.mvn.internal.Settings;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.property.PropertyStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationImpl
extends PropertyStore
implements Configuration {
    private static final Log LOGGER = LogFactory.getLog(ConfigurationImpl.class);
    private static final String REPOSITORIES_APPEND_SIGN = "+";
    private static final String REPOSITORIES_SEPARATOR = ",";
    private Settings m_settings;
    private final PropertyResolver m_propertyResolver;

    public ConfigurationImpl(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        this.m_propertyResolver = propertyResolver;
    }

    public void setSettings(Settings settings) {
        this.m_settings = settings;
    }

    @Override
    public Boolean getCertificateCheck() {
        if (!this.contains("org.ops4j.pax.url.mvn.certificateCheck")) {
            return this.set("org.ops4j.pax.url.mvn.certificateCheck", Boolean.valueOf(this.m_propertyResolver.get("org.ops4j.pax.url.mvn.certificateCheck")));
        }
        return (Boolean)this.get("org.ops4j.pax.url.mvn.certificateCheck");
    }

    @Override
    public URL getSettingsFileUrl() {
        block6: {
            String spec;
            if (!this.contains("org.ops4j.pax.url.mvn.settings") && (spec = this.m_propertyResolver.get("org.ops4j.pax.url.mvn.settings")) != null) {
                try {
                    return this.set("org.ops4j.pax.url.mvn.settings", new URL(spec));
                }
                catch (MalformedURLException e) {
                    File file = new File(spec);
                    if (file.exists()) {
                        try {
                            return this.set("org.ops4j.pax.url.mvn.settings", file.toURL());
                        }
                        catch (MalformedURLException ignore) {
                            break block6;
                        }
                    }
                    LOGGER.warn("Settings file [" + spec + "] cannot be used and will be skipped (malformed url or file does not exist)");
                    this.set("org.ops4j.pax.url.mvn.settings", null);
                }
            }
        }
        return (URL)this.get("org.ops4j.pax.url.mvn.settings");
    }

    @Override
    public List<RepositoryURL> getRepositories() throws MalformedURLException {
        if (!this.contains("org.ops4j.pax.url.mvn.repositories")) {
            String settingsRepos;
            String repositoriesProp = this.m_propertyResolver.get("org.ops4j.pax.url.mvn.repositories");
            if ((repositoriesProp == null || repositoriesProp.startsWith(REPOSITORIES_APPEND_SIGN)) && this.m_settings != null && (settingsRepos = this.m_settings.getRepositories()) != null) {
                repositoriesProp = repositoriesProp == null ? settingsRepos : repositoriesProp.substring(1) + REPOSITORIES_SEPARATOR + settingsRepos;
            }
            ArrayList<RepositoryURL> repositoriesProperty = new ArrayList<RepositoryURL>();
            RepositoryURL localRepository = this.getLocalRepository();
            if (localRepository != null) {
                repositoriesProperty.add(localRepository);
            }
            if (repositoriesProp != null && repositoriesProp.trim().length() > 0) {
                String[] repositories;
                for (String repositoryURL : repositories = repositoriesProp.split(REPOSITORIES_SEPARATOR)) {
                    repositoriesProperty.add(new RepositoryURL(repositoryURL));
                }
            }
            LOGGER.trace("Using repositories [" + repositoriesProperty + "]");
            return this.set("org.ops4j.pax.url.mvn.repositories", repositoriesProperty);
        }
        return (List)this.get("org.ops4j.pax.url.mvn.repositories");
    }

    @Override
    public RepositoryURL getLocalRepository() {
        if (!this.contains("org.ops4j.pax.url.mvn.localRepository")) {
            String spec = this.m_propertyResolver.get("org.ops4j.pax.url.mvn.localRepository");
            if (spec == null && this.m_settings != null) {
                spec = this.m_settings.getLocalRepository();
            }
            if (spec != null) {
                if (!spec.toLowerCase().contains("@snapshots")) {
                    spec = spec + "@snapshots";
                }
                try {
                    return this.set("org.ops4j.pax.url.mvn.localRepository", new RepositoryURL(spec));
                }
                catch (MalformedURLException e) {
                    try {
                        return this.set("org.ops4j.pax.url.mvn.localRepository", new RepositoryURL(new File(spec).toURI().toASCIIString()));
                    }
                    catch (MalformedURLException ignore) {
                        LOGGER.warn("Local repository [" + spec + "] cannot be used and will be skipped");
                        return this.set("org.ops4j.pax.url.mvn.localRepository", null);
                    }
                }
            }
        }
        return (RepositoryURL)this.get("org.ops4j.pax.url.mvn.localRepository");
    }

    @Override
    public void enableProxy(URL url) {
        String proxySupport = this.m_propertyResolver.get("org.ops4j.pax.url.mvn.proxySupport");
        if ("false".equalsIgnoreCase(proxySupport)) {
            return;
        }
        String protocol = url.getProtocol();
        if (protocol == null || protocol.equals(this.get("org.ops4j.pax.url.mvn.proxySupport"))) {
            return;
        }
        Map<String, String> proxyDetails = this.m_settings.getProxySettings().get(protocol);
        if (proxyDetails != null) {
            LOGGER.trace("Enabling proxy [" + proxyDetails + "]");
            final String user = proxyDetails.get("user");
            final String pass = proxyDetails.get("pass");
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pass.toCharArray());
                }
            });
            System.setProperty("http.proxyHost", proxyDetails.get("host"));
            System.setProperty("http.proxyPort", proxyDetails.get("port"));
            System.setProperty("http.nonProxyHosts", proxyDetails.get("nonProxyHosts"));
            this.set("org.ops4j.pax.url.mvn.proxySupport", protocol);
        }
    }
}

