/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jbi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.jbi.JBIConduitOutputStream;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class JBIConduit
extends AbstractConduit {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIConduit.class);
    private DeliveryChannel channel;
    private Bus bus;

    public JBIConduit(EndpointReferenceType target, DeliveryChannel dc) {
        this(null, target, dc);
    }

    public JBIConduit(Bus b, EndpointReferenceType target, DeliveryChannel dc) {
        super(target);
        this.channel = dc;
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void prepare(Message message) throws IOException {
        this.getLogger().log(Level.FINE, "JBIConduit send message");
        message.setContent(OutputStream.class, (Object)new JBIConduitOutputStream(message, this.channel, this.target, this));
    }
}

