/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ra.ActiveMQConnectionRequestInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQConnectionSupport {
    private ActiveMQConnectionRequestInfo info = new ActiveMQConnectionRequestInfo();
    protected Log log = LogFactory.getLog(this.getClass());

    protected ActiveMQConnectionFactory createConnectionFactory(ActiveMQConnectionRequestInfo connectionRequestInfo) {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        connectionRequestInfo.configure(factory);
        return factory;
    }

    public ActiveMQConnection makeConnection(ActiveMQConnectionRequestInfo connectionRequestInfo) throws JMSException {
        return this.makeConnection(connectionRequestInfo, this.createConnectionFactory(connectionRequestInfo));
    }

    public ActiveMQConnection makeConnection(ActiveMQConnectionRequestInfo connectionRequestInfo, ActiveMQConnectionFactory connectionFactory) throws JMSException {
        String userName = connectionRequestInfo.getUserName();
        String password = connectionRequestInfo.getPassword();
        ActiveMQConnection physicalConnection = (ActiveMQConnection)connectionFactory.createConnection(userName, password);
        String clientId = connectionRequestInfo.getClientid();
        if (clientId != null && clientId.length() > 0) {
            physicalConnection.setClientID(clientId);
        }
        return physicalConnection;
    }

    public ActiveMQConnectionRequestInfo getInfo() {
        return this.info;
    }

    protected void setInfo(ActiveMQConnectionRequestInfo connectionRequestInfo) {
        this.info = connectionRequestInfo;
    }

    protected boolean notEqual(Object o1, Object o2) {
        return o1 == null ^ o2 == null || o1 != null && !o1.equals(o2);
    }

    protected String emptyToNull(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    protected String defaultValue(String value, String defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getClientid() {
        return this.emptyToNull(this.info.getClientid());
    }

    public void setClientid(String clientid) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [clientid] to: " + clientid));
        }
        this.info.setClientid(clientid);
    }

    public String getPassword() {
        return this.emptyToNull(this.info.getPassword());
    }

    public void setPassword(String password) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"setting [password] property");
        }
        this.info.setPassword(password);
    }

    public String getServerUrl() {
        return this.info.getServerUrl();
    }

    public void setServerUrl(String url) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [serverUrl] to: " + url));
        }
        this.info.setServerUrl(url);
    }

    public String getUserName() {
        return this.emptyToNull(this.info.getUserName());
    }

    public void setUserName(String userid) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [userName] to: " + userid));
        }
        this.info.setUserName(userid);
    }

    public Integer getDurableTopicPrefetch() {
        return this.info.getDurableTopicPrefetch();
    }

    public void setDurableTopicPrefetch(Integer durableTopicPrefetch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [durableTopicPrefetch] to: " + durableTopicPrefetch));
        }
        this.info.setDurableTopicPrefetch(durableTopicPrefetch);
    }

    public Long getInitialRedeliveryDelay() {
        return this.info.getInitialRedeliveryDelay();
    }

    public void setInitialRedeliveryDelay(Long value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [initialRedeliveryDelay] to: " + value));
        }
        this.info.setInitialRedeliveryDelay(value);
    }

    public Integer getInputStreamPrefetch() {
        return this.info.getInputStreamPrefetch();
    }

    public void setInputStreamPrefetch(Integer inputStreamPrefetch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [inputStreamPrefetch] to: " + inputStreamPrefetch));
        }
        this.info.setInputStreamPrefetch(inputStreamPrefetch);
    }

    public Integer getMaximumRedeliveries() {
        return this.info.getMaximumRedeliveries();
    }

    public void setMaximumRedeliveries(Integer value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [maximumRedeliveries] to: " + value));
        }
        this.info.setMaximumRedeliveries(value);
    }

    public Integer getQueueBrowserPrefetch() {
        return this.info.getQueueBrowserPrefetch();
    }

    public void setQueueBrowserPrefetch(Integer queueBrowserPrefetch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [queueBrowserPrefetch] to: " + queueBrowserPrefetch));
        }
        this.info.setQueueBrowserPrefetch(queueBrowserPrefetch);
    }

    public Integer getQueuePrefetch() {
        return this.info.getQueuePrefetch();
    }

    public void setQueuePrefetch(Integer queuePrefetch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [queuePrefetch] to: " + queuePrefetch));
        }
        this.info.setQueuePrefetch(queuePrefetch);
    }

    public Short getRedeliveryBackOffMultiplier() {
        return this.info.getRedeliveryBackOffMultiplier();
    }

    public void setRedeliveryBackOffMultiplier(Short value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [redeliveryBackOffMultiplier] to: " + value));
        }
        this.info.setRedeliveryBackOffMultiplier(value);
    }

    public Boolean getRedeliveryUseExponentialBackOff() {
        return this.info.getRedeliveryUseExponentialBackOff();
    }

    public void setRedeliveryUseExponentialBackOff(Boolean value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [redeliveryUseExponentialBackOff] to: " + value));
        }
        this.info.setRedeliveryUseExponentialBackOff(value);
    }

    public Integer getTopicPrefetch() {
        return this.info.getTopicPrefetch();
    }

    public void setTopicPrefetch(Integer topicPrefetch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [topicPrefetch] to: " + topicPrefetch));
        }
        this.info.setTopicPrefetch(topicPrefetch);
    }

    public void setAllPrefetchValues(Integer i) {
        this.info.setAllPrefetchValues(i);
    }

    public boolean isUseInboundSessionEnabled() {
        return this.info.isUseInboundSessionEnabled();
    }

    public Boolean getUseInboundSession() {
        return this.info.getUseInboundSession();
    }

    public void setUseInboundSession(Boolean useInboundSession) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting [useInboundSession] to: " + useInboundSession));
        }
        this.info.setUseInboundSession(useInboundSession);
    }
}

