/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.osworkflow;

import java.util.HashMap;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.osworkflow.OSWorkflow;
import org.apache.servicemix.osworkflow.OSWorkflowComponent;

public class OSWorkflowEndpoint
extends ProviderEndpoint {
    private static final long TIME_OUT = 30000L;
    private String workflowName;
    private String caller;
    private int action;
    private Executor executor;
    private SourceTransformer sourceTransformer = new SourceTransformer();

    public void start() throws Exception {
        super.start();
        OSWorkflowComponent component = (OSWorkflowComponent)this.getServiceUnit().getComponent();
        this.executor = component.getExecutorFactory().createExecutor("component." + component.getComponentName() + "." + EndpointSupport.getKey((Endpoint)this));
    }

    public void stop() throws Exception {
        this.executor.shutdown();
        super.stop();
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange == null) {
            return;
        }
        if (exchange.getRole() == MessageExchange.Role.CONSUMER) {
            this.onConsumerExchange(exchange);
        } else if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            this.onProviderExchange(exchange);
        } else {
            throw new MessagingException("OSWorkflowEndpoint.onMessageExchange(): Unknown role: " + exchange.getRole());
        }
    }

    protected void onConsumerExchange(MessageExchange exchange) throws MessagingException {
        if (exchange.getMessage("out") != null) {
            this.done(exchange);
        } else if (exchange.getFault() != null) {
            this.done(exchange);
        } else {
            throw new MessagingException("OSWorkflowEndpoint.onConsumerExchange(): Consumer exchange is ACTIVE, but no out or fault is provided");
        }
    }

    protected void onProviderExchange(MessageExchange exchange) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        if (exchange.getFault() != null) {
            this.done(exchange);
        } else {
            NormalizedMessage in = exchange.getMessage("in");
            if (in == null) {
                throw new MessagingException("OSWorkflowEndpoint.onProviderExchange(): Exchange has no IN message");
            }
            OSWorkflow osWorkflow = new OSWorkflow(this, this.workflowName, this.action, new HashMap(), this.caller, exchange);
            this.executor.execute((Runnable)osWorkflow);
        }
    }

    public boolean sendMessage(QName service, Source source) throws MessagingException {
        InOnly inOnly = this.getChannel().createExchangeFactoryForService(service).createInOnlyExchange();
        NormalizedMessage msg = inOnly.createMessage();
        msg.setContent(source);
        inOnly.setInMessage(msg);
        if (this.getChannel().sendSync((MessageExchange)inOnly)) {
            return inOnly.getStatus() == ExchangeStatus.DONE;
        }
        return false;
    }

    public Source sendRequest(QName service, Source source) throws MessagingException {
        InOut inOut = this.getChannel().createExchangeFactoryForService(service).createInOutExchange();
        NormalizedMessage msg = inOut.createMessage();
        msg.setContent(source);
        inOut.setInMessage(msg);
        if (this.getChannel().sendSync((MessageExchange)inOut)) {
            try {
                DOMSource result = this.sourceTransformer.toDOMSource(inOut.getOutMessage().getContent());
                this.done((MessageExchange)inOut);
                return result;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public MessageExchange sendRawInOutRequest(QName service, Source source) throws MessagingException {
        InOut inOut = this.getChannel().createExchangeFactoryForService(service).createInOutExchange();
        NormalizedMessage msg = inOut.createMessage();
        msg.setContent(source);
        inOut.setInMessage(msg);
        if (this.getChannel().sendSync((MessageExchange)inOut)) {
            return inOut;
        }
        return null;
    }

    public MessageExchange getNewExchange(QName qname, boolean inOut) throws MessagingException {
        Object exchange = null;
        exchange = inOut ? this.getChannel().createExchangeFactoryForService(qname).createInOutExchange() : this.getChannel().createExchangeFactoryForService(qname).createInOnlyExchange();
        return exchange;
    }

    public void done(MessageExchange ex) throws MessagingException {
        super.done(ex);
    }

    public void send(MessageExchange ex, boolean sync) throws MessagingException {
        if (sync) {
            this.getChannel().sendSync(ex, 30000L);
        } else {
            this.getChannel().send(ex);
        }
    }

    public void fail(MessageExchange ex) throws MessagingException {
        super.fail(ex, new Exception("Failure"));
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public String getCaller() {
        return this.caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public void preWorkflow() {
    }

    public void postWorkflow() {
    }
}

