/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.util.ExchangeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataSetSupport
implements DataSet {
    private Map<String, Object> defaultHeaders;
    private Processor outputTransformer;
    private long size = 10L;
    private long reportCount = -1L;

    public DataSetSupport() {
    }

    public DataSetSupport(int size) {
        this.setSize(size);
    }

    @Override
    public void populateMessage(Exchange exchange, long messageIndex) throws Exception {
        Message in = exchange.getIn();
        in.setBody(this.createMessageBody(messageIndex));
        in.setHeaders(this.getDefaultHeaders());
        this.applyHeaders(exchange, messageIndex);
        if (this.outputTransformer != null) {
            this.outputTransformer.process(exchange);
        }
    }

    @Override
    public void assertMessageExpected(DataSetEndpoint dataSetEndpoint, Exchange expected, Exchange actual, long index) throws Exception {
        Object expectedBody = expected.getIn().getBody();
        Object actualBody = actual.getIn().getBody();
        if (expectedBody != null) {
            actualBody = ExchangeHelper.getMandatoryInBody(actual, expectedBody.getClass());
        }
        DataSetEndpoint.assertEquals("message body", expectedBody, actualBody, actual);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getReportCount() {
        if (this.reportCount <= 0L) {
            this.reportCount = this.getSize() / 5L;
        }
        return this.reportCount;
    }

    public void setReportCount(long reportCount) {
        this.reportCount = reportCount;
    }

    public Map<String, Object> getDefaultHeaders() {
        if (this.defaultHeaders == null) {
            this.defaultHeaders = new HashMap<String, Object>();
            this.populateDefaultHeaders(this.defaultHeaders);
        }
        return this.defaultHeaders;
    }

    public void setDefaultHeaders(Map<String, Object> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public Processor getOutputTransformer() {
        return this.outputTransformer;
    }

    public void setOutputTransformer(Processor outputTransformer) {
        this.outputTransformer = outputTransformer;
    }

    protected abstract Object createMessageBody(long var1);

    protected void applyHeaders(Exchange exchange, long messageIndex) {
    }

    protected void populateDefaultHeaders(Map<String, Object> map) {
    }
}

