/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.loadbalancer.LoadBalancerType;
import org.apache.camel.model.loadbalancer.RandomLoadBalanceStrategy;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalanceStrategy;
import org.apache.camel.model.loadbalancer.StickyLoadBalanceStrategy;
import org.apache.camel.model.loadbalancer.TopicLoadBalanceStrategy;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.RandomLoadBalancer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;
import org.apache.camel.processor.loadbalancer.StickyLoadBalancer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CollectionStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="loadBalance")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LoadBalanceType
extends ProcessorType<LoadBalanceType> {
    @XmlAttribute(required=false)
    private String ref;
    @XmlElements(value={@XmlElement(required=false, name="roundRobin", type=RoundRobinLoadBalanceStrategy.class), @XmlElement(required=false, name="random", type=RandomLoadBalanceStrategy.class), @XmlElement(required=false, name="sticky", type=StickyLoadBalanceStrategy.class), @XmlElement(required=false, name="topic", type=TopicLoadBalanceStrategy.class)})
    private LoadBalancerType loadBalancerType;
    @XmlElementRef
    private List<ProcessorType<?>> outputs = new ArrayList();

    @Override
    public String getShortName() {
        return "loadbalance";
    }

    @Override
    public List<ProcessorType<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorType<?>> outputs) {
        this.outputs = outputs;
        if (outputs != null) {
            for (ProcessorType<?> output : outputs) {
                this.configureChild(output);
            }
        }
    }

    @Override
    protected void configureChild(ProcessorType output) {
        super.configureChild(output);
        if (this.isInheritErrorHandler()) {
            output.setErrorHandlerBuilder(this.getErrorHandlerBuilder());
        }
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public LoadBalancerType getLoadBalancerType() {
        return this.loadBalancerType;
    }

    public void setLoadBalancerType(LoadBalancerType loadbalancer) {
        this.loadBalancerType = loadbalancer;
    }

    @Override
    protected Processor createOutputsProcessor(RouteContext routeContext, Collection<ProcessorType<?>> outputs) throws Exception {
        LoadBalancer loadBalancer = LoadBalancerType.getLoadBalancer(routeContext, this.loadBalancerType, this.ref);
        for (ProcessorType<?> processorType : outputs) {
            SendProcessor processor = (SendProcessor)processorType.createProcessor(routeContext);
            loadBalancer.addProcessor(processor);
        }
        return loadBalancer;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        LoadBalancer loadBalancer = LoadBalancerType.getLoadBalancer(routeContext, this.loadBalancerType, this.ref);
        for (ProcessorType<?> processorType : this.getOutputs()) {
            Processor processor = processorType.createProcessor(routeContext);
            processor = processorType.wrapProcessorInInterceptors(routeContext, processor);
            loadBalancer.addProcessor(processor);
        }
        return loadBalancer;
    }

    public LoadBalanceType setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancerType = new LoadBalancerType(loadBalancer);
        return this;
    }

    public LoadBalanceType roundRobin() {
        this.loadBalancerType = new LoadBalancerType(new RoundRobinLoadBalancer());
        return this;
    }

    public LoadBalanceType random() {
        this.loadBalancerType = new LoadBalancerType(new RandomLoadBalancer());
        return this;
    }

    public LoadBalanceType sticky(Expression<Exchange> correlationExpression) {
        this.loadBalancerType = new LoadBalancerType(new StickyLoadBalancer(correlationExpression));
        return this;
    }

    public LoadBalanceType topic() {
        this.loadBalancerType = new LoadBalancerType(new TopicLoadBalancer());
        return this;
    }

    @Override
    public String getLabel() {
        CollectionStringBuffer buffer = new CollectionStringBuffer();
        List<ProcessorType<?>> list = this.getOutputs();
        for (ProcessorType<?> processorType : list) {
            buffer.append(processorType.getLabel());
        }
        return buffer.toString();
    }

    public String toString() {
        if (this.loadBalancerType != null) {
            return "LoadBalanceType[" + this.loadBalancerType + ", " + this.getOutputs() + "]";
        }
        return "LoadBalanceType[ref: " + this.ref + ", " + this.getOutputs() + "]";
    }
}

