/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="methodCall")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MethodCallExpression
extends ExpressionType {
    @XmlAttribute(required=false)
    private String bean;
    @XmlAttribute(required=false)
    private String method;

    public MethodCallExpression() {
    }

    public MethodCallExpression(String beanName) {
        super(beanName);
    }

    public MethodCallExpression(String beanName, String method) {
        super(beanName);
        this.method = method;
    }

    @Override
    public String getLanguage() {
        return "bean";
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public Expression createExpression(RouteContext routeContext) {
        return new BeanExpression(this.beanName(), this.getMethod());
    }

    @Override
    public Predicate<Exchange> createPredicate(RouteContext routeContext) {
        return new BeanExpression<Exchange>(this.beanName(), this.getMethod());
    }

    protected String beanName() {
        if (this.bean != null) {
            return this.bean;
        }
        return this.getExpression();
    }
}

