/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Random;
import org.apache.camel.model.LoggingLevel;
import org.apache.camel.processor.DelayPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RedeliveryPolicy
extends DelayPolicy {
    protected static transient Random randomNumberGenerator;
    private static final transient Log LOG;
    protected int maximumRedeliveries = 5;
    protected long maximumRedeliveryDelay = 60000L;
    protected double backOffMultiplier = 2.0;
    protected boolean useExponentialBackOff;
    protected double collisionAvoidanceFactor = 0.15;
    protected boolean useCollisionAvoidance;
    protected LoggingLevel retriesExhaustedLogLevel = LoggingLevel.ERROR;
    protected LoggingLevel retryAttemptedLogLevel = LoggingLevel.ERROR;

    public String toString() {
        return "RedeliveryPolicy[maximumRedeliveries=" + this.maximumRedeliveries + ", initialRedeliveryDelay=" + this.delay + ", maximumRedeliveryDelay=" + this.maximumRedeliveryDelay + ", retriesExhaustedLogLevel=" + (Object)((Object)this.retriesExhaustedLogLevel) + ", retryAttemptedLogLevel=" + (Object)((Object)this.retryAttemptedLogLevel) + ", useExponentialBackOff=" + this.useExponentialBackOff + ", backOffMultiplier=" + this.backOffMultiplier + ", useCollisionAvoidance=" + this.useCollisionAvoidance + ", collisionAvoidanceFactor=" + this.collisionAvoidanceFactor + "]";
    }

    public RedeliveryPolicy copy() {
        try {
            return (RedeliveryPolicy)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone: " + e, e);
        }
    }

    public boolean shouldRedeliver(int redeliveryCounter) {
        if (this.getMaximumRedeliveries() < 0) {
            return true;
        }
        return redeliveryCounter <= this.getMaximumRedeliveries();
    }

    public long sleep(long redeliveryDelay) {
        block4: {
            if ((redeliveryDelay = this.getRedeliveryDelay(redeliveryDelay)) > 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Sleeping for: " + redeliveryDelay + " millis until attempting redelivery"));
                }
                try {
                    Thread.sleep(redeliveryDelay);
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)("Thread interrupted: " + e), (Throwable)e);
                }
            }
        }
        return redeliveryDelay;
    }

    public long getRedeliveryDelay(long previousDelay) {
        long redeliveryDelay = previousDelay == 0L ? this.delay : (this.useExponentialBackOff && this.backOffMultiplier > 1.0 ? Math.round(this.backOffMultiplier * (double)previousDelay) : previousDelay);
        if (this.useCollisionAvoidance) {
            Random random = RedeliveryPolicy.getRandomNumberGenerator();
            double variance = (random.nextBoolean() ? this.collisionAvoidanceFactor : -this.collisionAvoidanceFactor) * random.nextDouble();
            redeliveryDelay = (long)((double)redeliveryDelay + (double)redeliveryDelay * variance);
        }
        if (this.maximumRedeliveryDelay > 0L && redeliveryDelay > this.maximumRedeliveryDelay) {
            redeliveryDelay = this.maximumRedeliveryDelay;
        }
        return redeliveryDelay;
    }

    public RedeliveryPolicy maximumRedeliveries(int maximumRedeliveries) {
        this.setMaximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public RedeliveryPolicy initialRedeliveryDelay(long initialRedeliveryDelay) {
        this.setDelay(initialRedeliveryDelay);
        return this;
    }

    public RedeliveryPolicy useCollisionAvoidance() {
        this.setUseCollisionAvoidance(true);
        return this;
    }

    public RedeliveryPolicy useExponentialBackOff() {
        this.setUseExponentialBackOff(true);
        return this;
    }

    public RedeliveryPolicy backOffMultiplier(double multiplier) {
        this.useExponentialBackOff();
        this.setBackOffMultiplier(multiplier);
        return this;
    }

    public RedeliveryPolicy collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.useCollisionAvoidance();
        this.setCollisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public RedeliveryPolicy maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.setMaximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public RedeliveryPolicy retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.setRetriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public RedeliveryPolicy retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.setRetryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public short getCollisionAvoidancePercent() {
        return (short)Math.round(this.collisionAvoidanceFactor * 100.0);
    }

    public void setCollisionAvoidancePercent(double collisionAvoidancePercent) {
        this.collisionAvoidanceFactor = collisionAvoidancePercent * 0.01;
    }

    public double getCollisionAvoidanceFactor() {
        return this.collisionAvoidanceFactor;
    }

    public void setCollisionAvoidanceFactor(double collisionAvoidanceFactor) {
        this.collisionAvoidanceFactor = collisionAvoidanceFactor;
    }

    public long getInitialRedeliveryDelay() {
        return this.getDelay();
    }

    public void setInitialRedeliveryDelay(long initialRedeliveryDelay) {
        this.setDelay(initialRedeliveryDelay);
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public long getMaximumRedeliveryDelay() {
        return this.maximumRedeliveryDelay;
    }

    public void setMaximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.maximumRedeliveryDelay = maximumRedeliveryDelay;
    }

    public boolean isUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(boolean useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    protected static synchronized Random getRandomNumberGenerator() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
        return randomNumberGenerator;
    }

    public void setRetriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.retriesExhaustedLogLevel = retriesExhaustedLogLevel;
    }

    public LoggingLevel getRetriesExhaustedLogLevel() {
        return this.retriesExhaustedLogLevel;
    }

    public void setRetryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.retryAttemptedLogLevel = retryAttemptedLogLevel;
    }

    public LoggingLevel getRetryAttemptedLogLevel() {
        return this.retryAttemptedLogLevel;
    }

    static {
        LOG = LogFactory.getLog(RedeliveryPolicy.class);
    }
}

