/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.List;
import org.apache.camel.model.ChoiceType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.WhenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessorTypeHelper {
    private ProcessorTypeHelper() {
    }

    public static <T> T findFirstTypeInOutputs(List<ProcessorType<?>> outputs, Class<T> type) {
        if (outputs == null || outputs.isEmpty()) {
            return null;
        }
        for (ProcessorType<?> out : outputs) {
            List<ProcessorType<?>> children;
            T child;
            if (type.isInstance(out)) {
                return type.cast(out);
            }
            if (out instanceof ChoiceType) {
                ChoiceType choice = (ChoiceType)out;
                for (WhenType when : choice.getWhenClauses()) {
                    List<ProcessorType<?>> children2 = when.getOutputs();
                    T child2 = ProcessorTypeHelper.findFirstTypeInOutputs(children2, type);
                    if (child2 == null) continue;
                    return child2;
                }
                List<ProcessorType<?>> children3 = choice.getOtherwise().getOutputs();
                T child3 = ProcessorTypeHelper.findFirstTypeInOutputs(children3, type);
                if (child3 != null) {
                    return child3;
                }
            }
            if ((child = ProcessorTypeHelper.findFirstTypeInOutputs(children = out.getOutputs(), type)) == null) continue;
            return child;
        }
        return null;
    }
}

