/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.model.FromType;
import org.apache.camel.model.InterceptorRef;
import org.apache.camel.model.MulticastType;
import org.apache.camel.model.PipelineType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.ToType;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.GraphGeneratorSupport;
import org.apache.camel.view.NodeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteDotGenerator
extends GraphGeneratorSupport {
    public RouteDotGenerator(String dir) {
        super(dir, ".dot");
    }

    protected void printRoutes(PrintWriter writer, Map<String, List<RouteType>> map) {
        Set<Map.Entry<String, List<RouteType>>> entries = map.entrySet();
        for (Map.Entry<String, List<RouteType>> entry : entries) {
            String group = entry.getKey();
            this.printRoutes(writer, group, entry.getValue());
        }
    }

    protected void printRoutes(PrintWriter writer, String group, List<RouteType> routes) {
        if (group != null) {
            writer.println("subgraph cluster_" + this.clusterCounter++ + " {");
            writer.println("label = \"" + group + "\";");
            writer.println("color = grey;");
            writer.println("style = \"dashed\";");
            writer.println("URL = \"" + group + ".html\";");
            writer.println();
        }
        for (RouteType route : routes) {
            List<FromType> inputs = route.getInputs();
            for (FromType input : inputs) {
                this.printRoute(writer, route, input);
            }
            writer.println();
        }
        if (group != null) {
            writer.println("}");
            writer.println();
        }
    }

    protected String escapeNodeId(String text) {
        return text.replace('.', '_').replace("$", "_");
    }

    protected void printRoute(PrintWriter writer, RouteType route, FromType input) {
        NodeData nodeData = this.getNodeData(input);
        this.printNode(writer, nodeData);
        NodeData from = nodeData;
        for (ProcessorType<?> output : route.getOutputs()) {
            NodeData newData;
            from = newData = this.printNode(writer, from, output);
        }
    }

    protected NodeData printNode(PrintWriter writer, NodeData fromData, ProcessorType node) {
        List<ProcessorType> outputs;
        if (node instanceof MulticastType || node instanceof InterceptorRef) {
            List<ProcessorType<?>> outputs2 = node.getOutputs();
            boolean isPipeline = RouteDotGenerator.isPipeline(node);
            for (ProcessorType<?> output : outputs2) {
                NodeData out = this.printNode(writer, fromData, output);
                if (!isPipeline) continue;
                fromData = out;
            }
            return fromData;
        }
        NodeData toData = this.getNodeData(node);
        this.printNode(writer, toData);
        if (fromData != null) {
            writer.print(fromData.id);
            writer.print(" -> ");
            writer.print(toData.id);
            writer.println(" [");
            String label = fromData.edgeLabel;
            if (ObjectHelper.isNotNullAndNonEmpty(label)) {
                writer.println("label = \"" + label + "\"");
            }
            writer.println("];");
        }
        if ((outputs = toData.outputs) != null) {
            for (ProcessorType output : outputs) {
                NodeData newData = this.printNode(writer, toData, output);
                if (this.isMulticastNode(node)) continue;
                toData = newData;
            }
        }
        return toData;
    }

    protected void printNode(PrintWriter writer, NodeData data) {
        if (!data.nodeWritten) {
            String shape;
            String image;
            data.nodeWritten = true;
            writer.println();
            writer.print(data.id);
            writer.println(" [");
            writer.println("label = \"" + data.label + "\"");
            writer.println("tooltip = \"" + data.tooltop + "\"");
            if (data.url != null) {
                writer.println("URL = \"" + data.url + "\"");
            }
            if ((image = data.image) != null) {
                writer.println("shapefile = \"" + image + "\"");
                writer.println("peripheries=0");
            }
            if ((shape = data.shape) == null && image != null) {
                shape = "custom";
            }
            if (shape != null) {
                writer.println("shape = \"" + shape + "\"");
            }
            writer.println("];");
            writer.println();
        }
    }

    @Override
    protected void generateFile(PrintWriter writer, Map<String, List<RouteType>> map) {
        writer.println("digraph CamelRoutes {");
        writer.println();
        writer.println("node [style = \"rounded,filled\", fillcolor = yellow, fontname=\"Helvetica-Oblique\"];");
        writer.println();
        this.printRoutes(writer, map);
        writer.println("}");
    }

    private static boolean isPipeline(ProcessorType node) {
        if (node instanceof MulticastType) {
            return false;
        }
        if (node instanceof PipelineType) {
            return true;
        }
        if (node.getOutputs().size() > 1) {
            for (ProcessorType<?> type : node.getOutputs()) {
                if (type instanceof ToType) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

