/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.servicemix.jbi.deployer.descriptor.Descriptor;
import org.apache.servicemix.jbi.deployer.descriptor.DescriptorFactory;
import org.apache.servicemix.jbi.deployer.handler.Builder;
import org.apache.servicemix.jbi.deployer.impl.FileUtil;

public class Transformer {
    private Transformer() {
    }

    public static void transformToOSGiBundle(File jbiArtifact, File osgiBundle) throws Exception {
        JarFile jar = new JarFile(jbiArtifact);
        Manifest m = jar.getManifest();
        if (m == null) {
            m = new Manifest();
            m.getMainAttributes().putValue("Manifest-Version", "1.0");
        }
        JarEntry jarEntry = jar.getJarEntry("META-INF/jbi.xml");
        InputStream is = jar.getInputStream(jarEntry);
        Descriptor desc = DescriptorFactory.buildDescriptor(is);
        String version = m.getMainAttributes().getValue("Implementation-Version");
        version = version != null ? Builder.cleanupVersion(version) : "0.0.0";
        String name = m.getMainAttributes().getValue("Implementation-Title");
        if (desc.getComponent() != null) {
            name = desc.getComponent().getIdentification().getName();
        } else if (desc.getSharedLibrary() != null) {
            name = desc.getSharedLibrary().getIdentification().getName();
        } else if (desc.getServiceAssembly() != null) {
            name = desc.getServiceAssembly().getIdentification().getName();
        }
        m.getMainAttributes().putValue("Bundle-SymbolicName", name);
        m.getMainAttributes().putValue("Bundle-Version", version);
        m.getMainAttributes().putValue("DynamicImport-Package", "javax.*,org.xml.*,org.w3c.*");
        JarInputStream jis = new JarInputStream(new FileInputStream(jbiArtifact));
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(osgiBundle), m);
        JarEntry entry = jis.getNextJarEntry();
        while (entry != null) {
            jos.putNextEntry(entry);
            FileUtil.copyInputStream(jis, jos);
            jos.closeEntry();
            entry = jis.getNextJarEntry();
        }
        jos.close();
        jis.close();
    }
}

