/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.moduleloader;

import java.net.URL;
import java.util.Enumeration;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.searchpolicy.ContentLoaderImpl;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IModuleDefinition;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ResourceNotFoundException;

public class ModuleImpl
implements IModule {
    private Logger m_logger = null;
    private String m_id = null;
    private boolean m_removalPending = false;
    private IModuleDefinition m_md = null;
    private IContentLoader m_contentLoader = null;
    private IModule[] m_fragments = null;
    private IWire[] m_wires = null;
    private IModule[] m_dependents = new IModule[0];

    ModuleImpl(Logger logger, String id, IModuleDefinition md) {
        this.m_logger = logger;
        this.m_id = id;
        this.m_md = md;
    }

    public String getId() {
        return this.m_id;
    }

    public IModuleDefinition getDefinition() {
        return this.m_md;
    }

    public IContentLoader getContentLoader() {
        return this.m_contentLoader;
    }

    protected void setContentLoader(IContentLoader contentLoader) {
        this.m_contentLoader = contentLoader;
    }

    public synchronized void attachFragments(IModule[] fragments) throws Exception {
        for (int i = 0; this.m_fragments != null && i < this.m_fragments.length; ++i) {
            ((ModuleImpl)this.m_fragments[i]).removeDependent(this);
        }
        this.m_fragments = fragments;
        if (this.m_fragments != null) {
            IContent[] fragmentContents = new IContent[this.m_fragments.length];
            for (int i = 0; this.m_fragments != null && i < this.m_fragments.length; ++i) {
                ((ModuleImpl)this.m_fragments[i]).addDependent(this);
                fragmentContents[i] = this.m_fragments[i].getContentLoader().getContent().getEntryAsContent(".");
            }
            ((ContentLoaderImpl)this.m_contentLoader).attachFragmentContents(fragmentContents);
        }
    }

    public synchronized IWire[] getWires() {
        return this.m_wires;
    }

    public synchronized void setWires(IWire[] wires) {
        int i;
        for (i = 0; this.m_wires != null && i < this.m_wires.length; ++i) {
            ((ModuleImpl)this.m_wires[i].getExporter()).removeDependent(this);
        }
        this.m_wires = wires;
        for (i = 0; wires != null && i < wires.length; ++i) {
            ((ModuleImpl)this.m_wires[i].getExporter()).addDependent(this);
        }
    }

    private synchronized void addDependent(IModule module) {
        for (int i = 0; i < this.m_dependents.length; ++i) {
            if (!this.m_dependents[i].equals(module)) continue;
            return;
        }
        IModule[] tmp = new IModule[this.m_dependents.length + 1];
        System.arraycopy(this.m_dependents, 0, tmp, 0, this.m_dependents.length);
        tmp[this.m_dependents.length] = module;
        this.m_dependents = tmp;
    }

    private synchronized void removeDependent(IModule module) {
        for (int i = 0; i < this.m_dependents.length; ++i) {
            if (!this.m_dependents[i].equals(module)) continue;
            if (this.m_dependents.length - 1 == 0) {
                this.m_dependents = new IModule[0];
                continue;
            }
            IModule[] tmp = new IModule[this.m_dependents.length - 1];
            System.arraycopy(this.m_dependents, 0, tmp, 0, i);
            if (i < tmp.length) {
                System.arraycopy(this.m_dependents, i + 1, tmp, i, tmp.length - i);
            }
            this.m_dependents = tmp;
        }
    }

    public synchronized IModule[] getDependents() {
        return this.m_dependents;
    }

    public boolean isRemovalPending() {
        return this.m_removalPending;
    }

    public void setRemovalPending(boolean removalPending) {
        this.m_removalPending = removalPending;
    }

    public Class getClass(String name) throws ClassNotFoundException {
        try {
            return this.m_contentLoader.getSearchPolicy().findClass(name);
        }
        catch (ClassNotFoundException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
            throw ex;
        }
    }

    public URL getResource(String name) {
        try {
            return this.m_contentLoader.getSearchPolicy().findResource(name);
        }
        catch (ResourceNotFoundException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
            return null;
        }
    }

    public Enumeration getResources(String name) {
        try {
            return this.m_contentLoader.getSearchPolicy().findResources(name);
        }
        catch (ResourceNotFoundException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
            return null;
        }
    }

    public String toString() {
        return this.m_id;
    }
}

