/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.common.tostring.ReflectionToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVariables
implements Variables {
    private final Map<String, Object> map;
    private final Variables parent;
    private final Set<String> immutables = new HashSet<String>();

    public DefaultVariables(Map<String, Object> map, Variables parent) {
        assert (map != null);
        assert (parent != null);
        this.map = map;
        this.parent = parent;
    }

    public DefaultVariables(Variables parent) {
        assert (parent != null);
        this.map = new HashMap<String, Object>();
        this.parent = parent;
    }

    public DefaultVariables(Map<String, Object> map) {
        assert (map != null);
        this.map = map;
        this.parent = null;
    }

    public DefaultVariables() {
        this(new HashMap<String, Object>());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    @Override
    public void set(String name, Object value) {
        this.set(name, value, true);
    }

    @Override
    public void set(String name, Object value, boolean mutable) {
        assert (name != null);
        this.ensureMutable(name);
        this.map.put(name, value);
        if (!mutable) {
            this.immutables.add(name);
        }
    }

    @Override
    public Object get(String name) {
        assert (name != null);
        Object value = this.map.get(name);
        if (value == null && this.parent != null) {
            value = this.parent.get(name);
        }
        return value;
    }

    @Override
    public Object get(String name, Object _default) {
        Object value = this.get(name);
        if (value == null) {
            return _default;
        }
        return value;
    }

    @Override
    public void unset(String name) {
        assert (name != null);
        this.ensureMutable(name);
        this.map.remove(name);
    }

    @Override
    public boolean contains(String name) {
        assert (name != null);
        return this.map.containsKey(name);
    }

    @Override
    public boolean isMutable(String name) {
        assert (name != null);
        boolean mutable = true;
        if (this.parent != null) {
            mutable = this.parent.isMutable(name);
        }
        if (mutable) {
            mutable = !this.immutables.contains(name);
        }
        return mutable;
    }

    private void ensureMutable(String name) {
        assert (name != null);
        if (!this.isMutable(name)) {
            throw new Variables.ImmutableVariableException(name);
        }
    }

    @Override
    public boolean isCloaked(String name) {
        assert (name != null);
        int count = 0;
        for (Variables vars = this; vars != null && count < 2; vars = vars.parent()) {
            if (!vars.contains(name)) continue;
            ++count;
        }
        return count > 1;
    }

    @Override
    public Iterator<String> names() {
        return new Iterator<String>(){
            Iterator<String> iter;
            boolean more;
            {
                this.iter = DefaultVariables.this.map.keySet().iterator();
                this.more = DefaultVariables.this.parent() != null;
            }

            @Override
            public boolean hasNext() {
                boolean next = this.iter.hasNext();
                if (!next && this.more) {
                    this.iter = DefaultVariables.this.parent().names();
                    this.more = false;
                    next = this.hasNext();
                }
                return next;
            }

            @Override
            public String next() {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Variables parent() {
        return this.parent;
    }

    public static boolean isIdentifier(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        char[] chars = name.toCharArray();
        return Character.isJavaIdentifierStart(chars[0]);
    }
}

