/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.branding;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.geronimo.gshell.branding.VersionLoader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.util.IOUtil;

@Component(role=VersionLoader.class)
public class PropertiesVersionLoader
implements VersionLoader {
    @Configuration(value="version.properties")
    private String resourceName;
    private Properties props;

    public PropertiesVersionLoader() {
    }

    public PropertiesVersionLoader(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getVersion() {
        if (this.props == null) {
            InputStream input = this.getClass().getResourceAsStream(this.resourceName);
            assert (input != null);
            try {
                this.props = new Properties();
                this.props.load(input);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load " + this.resourceName, e);
            }
            finally {
                IOUtil.close(input);
            }
        }
        return this.props.getProperty("version");
    }
}

