/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.clp.handler;

import org.apache.geronimo.gshell.clp.Descriptor;
import org.apache.geronimo.gshell.clp.ProcessingException;
import org.apache.geronimo.gshell.clp.handler.Handler;
import org.apache.geronimo.gshell.clp.handler.Messages;
import org.apache.geronimo.gshell.clp.handler.Parameters;
import org.apache.geronimo.gshell.clp.setter.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumHandler<T extends Enum<T>>
extends Handler<T> {
    private final Class<T> enumType;

    public EnumHandler(Descriptor desc, Setter<? super T> setter, Class<T> enumType) {
        super(desc, setter);
        assert (enumType != null);
        this.enumType = enumType;
    }

    @Override
    public int handle(Parameters params) throws ProcessingException {
        assert (params != null);
        String token = params.get(0);
        Enum value = null;
        for (Enum constant : (Enum[])this.enumType.getEnumConstants()) {
            if (!constant.name().equalsIgnoreCase(token)) continue;
            value = constant;
            break;
        }
        if (value == null) {
            throw new ProcessingException(Messages.ILLEGAL_OPERAND.format(this.descriptor.toString(), token));
        }
        this.setter.set(value);
        return 1;
    }

    @Override
    public String getDefaultMetaVariable() {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        for (Enum constants : (Enum[])this.enumType.getEnumConstants()) {
            buff.append(constants).append(" | ");
        }
        buff.delete(buff.length() - 3, buff.length());
        buff.append("]");
        return buff.toString();
    }
}

