/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.clp.setter;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.gshell.clp.IllegalAnnotationError;
import org.apache.geronimo.gshell.clp.setter.FieldSetter;
import org.apache.geronimo.gshell.clp.setter.Messages;

public class CollectionFieldSetter
extends FieldSetter {
    public CollectionFieldSetter(Object bean, Field field) {
        super(bean, field);
        if (!Collection.class.isAssignableFrom(field.getType())) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_FIELD_SIGNATURE.format(field.getType()));
        }
    }

    public boolean isMultiValued() {
        return true;
    }

    public Class getType() {
        ParameterizedType ptype;
        Type type = this.field.getGenericType();
        if (type instanceof ParameterizedType && (type = (ptype = (ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
            return (Class)type;
        }
        return Object.class;
    }

    protected void doSet(Object value) throws IllegalAccessException {
        AbstractCollection obj = this.field.get(this.bean);
        if (obj == null) {
            if (List.class.isAssignableFrom(this.field.getType())) {
                obj = new ArrayList();
            } else if (Set.class.isAssignableFrom(this.field.getType())) {
                obj = new HashSet();
            } else {
                throw new IllegalAnnotationError("Unsupported collection type: " + this.field.getType());
            }
            this.field.set(this.bean, obj);
        }
        if (!(obj instanceof Collection)) {
            throw new IllegalAnnotationError("Field is not a collection type: " + this.field);
        }
        ((Collection)obj).add(value);
    }
}

