/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtins;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.geronimo.gshell.DefaultVariables;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;

@CommandComponent(id="gshell-builtins:set", description="Set a variable")
public class SetCommand
extends OsgiCommandSupport {
    @Option(name="-m", aliases={"--mode"}, description="Set mode")
    private Mode mode = Mode.VARIABLE;
    @Argument(description="Variable definition")
    private List<String> args;

    protected Object doExecute() throws Exception {
        if (this.args == null || this.args.size() == 0) {
            switch (this.mode) {
                case PROPERTY: {
                    Properties props = System.getProperties();
                    for (Object o : props.keySet()) {
                        String name = (String)o;
                        String value = props.getProperty(name);
                        this.io.out.print(name);
                        this.io.out.print("=");
                        this.io.out.print(value);
                        this.io.out.println();
                    }
                    break;
                }
                case VARIABLE: {
                    Iterator<String> iter = this.variables.names();
                    while (iter.hasNext()) {
                        String name = iter.next();
                        Object value = this.variables.get(name);
                        this.io.out.print(name);
                        this.io.out.print("=");
                        this.io.out.print(value);
                        this.io.out.println();
                    }
                    break;
                }
            }
            return SUCCESS;
        }
        for (String arg : this.args) {
            String namevalue = String.valueOf(arg);
            switch (this.mode) {
                case PROPERTY: {
                    this.setProperty(namevalue);
                    break;
                }
                case VARIABLE: {
                    this.setVariable(namevalue);
                }
            }
        }
        return SUCCESS;
    }

    private NameValue parse(String input) {
        NameValue nv = new NameValue();
        int i = input.indexOf("=");
        if (i == -1) {
            nv.name = input;
            nv.value = "true";
        } else {
            nv.name = input.substring(0, i);
            nv.value = input.substring(i + 1, input.length());
        }
        nv.name = nv.name.trim();
        return nv;
    }

    private void ensureIsIdentifier(String name) {
        if (!DefaultVariables.isIdentifier(name)) {
            throw new RuntimeException("Invalid identifer name: " + name);
        }
    }

    private void setProperty(String namevalue) {
        NameValue nv = this.parse(namevalue);
        this.log.info("Setting system property: {}={}", (Object)nv.name, (Object)nv.value);
        this.ensureIsIdentifier(nv.name);
        System.setProperty(nv.name, nv.value);
    }

    private void setVariable(String namevalue) {
        NameValue nv = this.parse(namevalue);
        this.log.info("Setting variable: {}={}", (Object)nv.name, (Object)nv.value);
        this.ensureIsIdentifier(nv.name);
        Variables vars = this.variables.parent();
        vars.set(nv.name, nv.value);
    }

    class NameValue {
        String name;
        String value;

        NameValue() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        VARIABLE,
        PROPERTY;

    }
}

