/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandExecutor;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.command.annotation.Requirement;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.codehaus.plexus.util.IOUtil;

@CommandComponent(id="gshell-builtins:source", description="Load a file/url into the current shell")
public class SourceCommand
extends OsgiCommandSupport {
    @Requirement
    private CommandExecutor executor;
    @Argument(required=true, description="Source file")
    private String source;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        URL url;
        try {
            url = new URL(this.source);
        }
        catch (MalformedURLException e) {
            url = new File(this.source).toURI().toURL();
        }
        BufferedReader reader = this.openReader(url);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String tmp = line.trim();
                if (tmp.length() == 0 || tmp.startsWith("#")) continue;
                this.executor.execute(line);
            }
        }
        finally {
            IOUtil.close(reader);
        }
        return SUCCESS;
    }

    private BufferedReader openReader(Object source) throws IOException {
        BufferedReader reader;
        if (source instanceof File) {
            File file = (File)source;
            this.log.info("Using source file: {}", (Object)file);
            reader = new BufferedReader(new FileReader(file));
        } else if (source instanceof URL) {
            URL url = (URL)source;
            this.log.info("Using source URL: {}", (Object)url);
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
        } else {
            String tmp = String.valueOf(source);
            try {
                URL url = new URL(tmp);
                this.log.info("Using source URL: {}", (Object)url);
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
            }
            catch (MalformedURLException ignore) {
                File file = new File(tmp);
                this.log.info("Using source file: {}", (Object)file);
                reader = new BufferedReader(new FileReader(tmp));
            }
        }
        return reader;
    }
}

