/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtins;

import java.util.List;
import org.apache.geronimo.gshell.DefaultVariables;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;

@CommandComponent(id="gshell-builtins:unset", description="Unset a variable")
public class UnsetCommand
extends OsgiCommandSupport {
    @Option(name="-m", aliases={"--mode"}, description="Unset mode")
    private Mode mode = Mode.VARIABLE;
    @Argument(required=true, description="Variable name")
    private List<String> args;

    protected Object doExecute() throws Exception {
        for (String arg : this.args) {
            String namevalue = String.valueOf(arg);
            switch (this.mode) {
                case PROPERTY: {
                    this.unsetProperty(namevalue);
                    break;
                }
                case VARIABLE: {
                    this.unsetVariable(namevalue);
                }
            }
        }
        return SUCCESS;
    }

    private void ensureIsIdentifier(String name) {
        if (!DefaultVariables.isIdentifier(name)) {
            throw new RuntimeException("Invalid identifer name: " + name);
        }
    }

    private void unsetProperty(String name) {
        this.log.info("Unsetting system property: {}", (Object)name);
        this.ensureIsIdentifier(name);
        System.getProperties().remove(name);
    }

    private void unsetVariable(String name) {
        this.log.info("Unsetting variable: {}", (Object)name);
        this.ensureIsIdentifier(name);
        Variables vars = this.variables.parent();
        vars.unset(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        VARIABLE,
        PROPERTY;

    }
}

