/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.utils;

import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.common.io.PumpStreamHandler;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;

@CommandComponent(id="utils:exec", description="Execute system processes")
public class ExecuteCommand
extends OsgiCommandSupport {
    @Argument(description="Argument", required=true)
    private List<String> args;

    protected Object doExecute() throws Exception {
        ProcessBuilder builder = new ProcessBuilder(this.args);
        this.log.info("Executing: {}", builder.command());
        Process p = builder.start();
        PumpStreamHandler handler = new PumpStreamHandler(this.io.inputStream, this.io.outputStream, this.io.errorStream);
        handler.attach(p);
        handler.start();
        this.log.debug("Waiting for process to exit...");
        int status = p.waitFor();
        this.log.info("Process exited w/status: {}", (Object)status);
        handler.stop();
        return status;
    }
}

