/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.utils;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.codehaus.plexus.util.StringUtils;

@CommandComponent(id="utils:grep", description="Print lines matching a pattern")
public class GrepCommand
extends OsgiCommandSupport {
    @Argument(required=true, description="Regular expression")
    private String regex;
    @Option(name="-n", aliases={"--line-number"}, description="Prefix each line of output with the line number within its input file.")
    private boolean lineNumber;
    @Option(name="-v", aliases={"--invert-match"}, description="Invert the sense of matching, to select non-matching lines.")
    private boolean invertMatch;
    @Option(name="-w", aliases={"--word-regexp"}, description="Select only those lines containing matches that form whole words.  The test is that the matching substring must either be at  the beginning of the line, or preceded by a non-word constituent character.  Similarly, it must be either at the end of the line or followed by a non-word constituent character.  Word-constituent characters are letters, digits, and the underscore.")
    private boolean wordRegexp;
    @Option(name="-x", aliases={"--line-regexp"}, description="Select only those matches that exactly match the whole line.")
    private boolean lineRegexp;

    protected Object doExecute() throws Exception {
        String regexp = this.regex;
        if (this.wordRegexp) {
            regexp = "\\b" + regexp + "\\b";
        }
        regexp = this.lineRegexp ? "^" + regexp + "$" : ".*" + regexp + ".*";
        Pattern p = Pattern.compile(regexp);
        try {
            String line;
            int lineno = 1;
            while ((line = this.readLine(this.io.in)) != null) {
                if (!(p.matcher(line).matches() ^ this.invertMatch)) continue;
                if (this.lineNumber) {
                    String gutter = StringUtils.leftPad(String.valueOf(lineno), 6);
                    this.io.out.print(gutter);
                    this.io.out.print("  ");
                }
                this.io.out.println(line);
                ++lineno;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String readLine(Reader in) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int i;
            if ((i = in.read()) == -1 && buf.length() == 0) {
                throw new IOException("break");
            }
            if (i == -1 || i == 10 || i == 13) {
                return buf.toString();
            }
            buf.append((char)i);
        }
    }
}

