/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.utils;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.common.Arguments;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;

@CommandComponent(id="utils:java", description="Execute a Java standard application")
public class JavaCommand
extends OsgiCommandSupport {
    @Option(name="-m", aliases={"--method"}, metaVar="METHOD", description="Invoke a named method")
    private String methodName = "main";
    @Argument(index=0, metaVar="CLASSNAME", description="The name of the class to invoke", required=true)
    private String className;
    @Argument(index=1, metaVar="ARG", description="Arguments to pass to the METHOD of CLASSNAME")
    private List<String> args;

    protected Object doExecute() throws Exception {
        boolean info = this.log.isInfoEnabled();
        Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(this.className);
        if (info) {
            this.log.info("Using type: " + type);
        }
        Method method = type.getMethod(this.methodName, String[].class);
        if (info) {
            this.log.info("Using method: " + method);
        }
        if (info) {
            this.log.info("Invoking w/arguments: " + Arguments.asString(this.args));
        }
        Object result = method.invoke(null, this.args);
        if (info) {
            this.log.info("Result: " + result);
        }
        return SUCCESS;
    }
}

