/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.console;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Console
implements Runnable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected boolean running = false;
    protected boolean breakOnNull = true;
    protected boolean autoTrim = true;
    protected boolean ignoreEmpty = true;
    protected Prompter prompter = new Prompter(){

        public String prompt() {
            return "> ";
        }
    };
    protected Executor executor;
    protected ErrorHandler errorHandler = new ErrorHandler(){

        public ErrorHandler.Result handleError(Throwable error) {
            return ErrorHandler.Result.STOP;
        }
    };

    public Console(Executor executor) {
        assert (executor != null);
        this.executor = executor;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isBreakOnNull() {
        return this.breakOnNull;
    }

    public void setBreakOnNull(boolean breakOnNull) {
        this.breakOnNull = breakOnNull;
    }

    public boolean isAutoTrim() {
        return this.autoTrim;
    }

    public void setAutoTrim(boolean autoTrim) {
        this.autoTrim = autoTrim;
    }

    public boolean isIgnoreEmpty() {
        return this.ignoreEmpty;
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Prompter getPrompter() {
        return this.prompter;
    }

    public void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void run() {
        this.log.debug("Running");
        this.running = true;
        while (this.running) {
            try {
                this.running = this.work();
            }
            catch (Throwable t) {
                ErrorHandler.Result result;
                this.log.debug("Work failed: " + t, t);
                if (this.errorHandler == null || (result = this.errorHandler.handleError(t)) != ErrorHandler.Result.STOP) continue;
                this.log.debug("Error handler requested STOP");
                this.running = false;
            }
        }
        this.log.debug("Finished");
    }

    protected boolean work() throws Exception {
        String line = this.readLine(this.prompter.prompt());
        this.log.debug("Read line: {}", (Object)line);
        if (this.log.isTraceEnabled()) {
            byte[] bytes;
            StringBuffer idx = new StringBuffer();
            StringBuffer hex = new StringBuffer();
            for (byte b : bytes = line.getBytes()) {
                String h = Integer.toHexString(b);
                hex.append("x").append(h).append(" ");
                idx.append(" ").append((char)b).append("  ");
            }
            this.log.trace("HEX: {}", (Object)hex);
            this.log.trace("     {}", (Object)idx);
        }
        if (line == null) {
            return !this.breakOnNull;
        }
        if (this.autoTrim) {
            line = line.trim();
        }
        if (this.ignoreEmpty && line.length() == 0) {
            return true;
        }
        Executor.Result result = this.executor.execute(line);
        if (result == Executor.Result.STOP) {
            this.log.debug("Executor requested STOP");
            return false;
        }
        return true;
    }

    protected abstract String readLine(String var1) throws IOException;

    public static interface ErrorHandler {
        public Result handleError(Throwable var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Result {
            CONTINUE,
            STOP;

        }
    }

    public static interface Executor {
        public Result execute(String var1) throws Exception;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Result {
            CONTINUE,
            STOP;

        }
    }

    public static interface Prompter {
        public String prompt();
    }
}

