/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.console;

import java.io.File;
import java.io.IOException;
import jline.History;
import org.apache.geronimo.gshell.branding.Branding;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=History.class, hint="default")
public class FileHistory
extends History {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private Branding branding;

    public FileHistory() {
    }

    public FileHistory(Branding branding) throws IOException {
        this.branding = branding;
        this.initialize();
    }

    public void initialize() throws IOException {
        this.setHistoryFile(new File(this.branding.getUserDirectory(), this.branding.getHistoryFileName()));
    }

    public void setHistoryFile(File file) throws IOException {
        assert (file != null);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
            this.log.debug("Created base directory for history file: {}", (Object)dir);
        }
        this.log.debug("Using history file: {}", (Object)file);
        super.setHistoryFile(file);
    }
}

