/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.descriptor;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.Annotations;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.gshell.common.tostring.ReflectionToStringBuilder;
import org.apache.geronimo.gshell.common.tostring.ToStringStyle;
import org.apache.geronimo.gshell.descriptor.CommandDependency;
import org.apache.geronimo.gshell.descriptor.CommandDescriptor;
import org.apache.geronimo.gshell.descriptor.CommandParameter;
import org.apache.geronimo.gshell.descriptor.CommandRequirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="command-set")
public class CommandSetDescriptor {
    private String id;
    private String description;
    private List<CommandDescriptor> commands;

    public CommandSetDescriptor() {
    }

    public CommandSetDescriptor(String id) {
        this.id = id;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<CommandDescriptor> getCommands() {
        return this.commands;
    }

    public void setCommands(List<CommandDescriptor> commands) {
        this.commands = commands;
    }

    public void addCommand(CommandDescriptor command) {
        assert (command != null);
        if (this.commands == null) {
            this.commands = new ArrayList<CommandDescriptor>();
        }
        this.commands.add(command);
    }

    public int size() {
        List<CommandDescriptor> list = this.getCommands();
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static XStream createXStream() {
        XStream xs = new XStream((HierarchicalStreamDriver)new DomDriver());
        Annotations.configureAliases((XStream)xs, (Class[])new Class[]{CommandSetDescriptor.class, CommandDescriptor.class, CommandRequirement.class, CommandParameter.class, CommandDependency.class});
        return xs;
    }

    public static CommandSetDescriptor fromXML(Reader input) {
        assert (input != null);
        return (CommandSetDescriptor)CommandSetDescriptor.createXStream().fromXML(input);
    }

    public static String toXML(CommandSetDescriptor commands) {
        assert (commands != null);
        return CommandSetDescriptor.createXStream().toXML((Object)commands);
    }

    public static void toXML(CommandSetDescriptor commands, Writer writer) {
        assert (commands != null);
        assert (writer != null);
        CommandSetDescriptor.createXStream().toXML((Object)commands, writer);
    }
}

