/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.layout.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.geronimo.gshell.layout.loader.LayoutLoader;
import org.apache.geronimo.gshell.layout.model.Layout;
import org.apache.geronimo.gshell.layout.model.LayoutMarshaller;
import org.apache.geronimo.gshell.shell.ShellInfo;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=LayoutLoader.class)
public class XMLLayoutLoader
implements LayoutLoader,
Initializable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private ShellInfo info;
    private URI location;

    public XMLLayoutLoader() {
    }

    public XMLLayoutLoader(ShellInfo info) {
        this.info = info;
    }

    public void initialize() throws InitializationException {
        assert (this.info != null);
        this.location = new File(this.info.getHomeDir(), "etc/layout.xml").toURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Layout load(URI location) throws IOException {
        Layout layout;
        assert (location != null);
        this.log.debug("Loading layout from XML: {}", (Object)location);
        URL url = location.toURL();
        InputStream input = url.openStream();
        try {
            layout = LayoutMarshaller.unmarshal(input);
        }
        finally {
            IOUtil.close(input);
        }
        this.log.debug("Loaded layout: {}", (Object)layout);
        return layout;
    }

    public Layout load() throws IOException {
        return this.load(this.location);
    }
}

