/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.jaas;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class UsernamePasswordCallbackHandler
implements CallbackHandler {
    private final String username;
    private final char[] password;

    public UsernamePasswordCallbackHandler(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    public UsernamePasswordCallbackHandler(String username, String password) {
        this.username = username;
        this.password = (char[])(password != null ? password.toCharArray() : null);
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                nc.setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback;
                if (this.password != null) {
                    pc.setPassword(this.password);
                    continue;
                }
                pc.setPassword(null);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

